/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document;

import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableKeysAndAttributes {
    private final String tableName;
    private List<PrimaryKey> primaryKeys;
    private Set<String> attributeNames;
    private boolean consistentRead;
    private String projectionExpression;
    private Map<String, String> nameMap;

    public TableKeysAndAttributes(String tableName) {
        if (tableName == null || tableName.trim().length() == 0) {
            throw new IllegalArgumentException("table name must not be null or empty");
        }
        this.tableName = tableName;
    }

    public List<PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public TableKeysAndAttributes withPrimaryKeys(PrimaryKey ... primaryKeys) {
        if (primaryKeys == null) {
            this.primaryKeys = null;
        } else {
            Set<String> pkNameSet = null;
            for (PrimaryKey pk : primaryKeys) {
                if (pkNameSet == null) {
                    pkNameSet = pk.getComponentNameSet();
                    continue;
                }
                if (pkNameSet.equals(pk.getComponentNameSet())) continue;
                throw new IllegalArgumentException("primary key attribute names must be consistent for the specified primary keys");
            }
            this.primaryKeys = new ArrayList<PrimaryKey>(Arrays.asList(primaryKeys));
        }
        return this;
    }

    public TableKeysAndAttributes withHashOnlyKeys(String hashKeyName, Object ... hashKeyValues) {
        if (hashKeyName == null) {
            throw new IllegalArgumentException();
        }
        PrimaryKey[] primaryKeys = new PrimaryKey[hashKeyValues.length];
        for (int i = 0; i < hashKeyValues.length; ++i) {
            primaryKeys[i] = new PrimaryKey(hashKeyName, hashKeyValues[i]);
        }
        return this.withPrimaryKeys(primaryKeys);
    }

    public TableKeysAndAttributes withHashAndRangeKeys(String hashKeyName, String rangeKeyName, Object ... alternatingHashAndRangeKeyValues) {
        if (hashKeyName == null) {
            throw new IllegalArgumentException("hash key name must be specified");
        }
        if (rangeKeyName == null) {
            throw new IllegalArgumentException("range key name must be specified");
        }
        if (alternatingHashAndRangeKeyValues.length % 2 != 0) {
            throw new IllegalArgumentException("number of hash and range key values must be the same");
        }
        int len = alternatingHashAndRangeKeyValues.length / 2;
        PrimaryKey[] primaryKeys = new PrimaryKey[len];
        for (int i = 0; i < alternatingHashAndRangeKeyValues.length; i += 2) {
            primaryKeys[i >> 1] = new PrimaryKey(hashKeyName, alternatingHashAndRangeKeyValues[i], rangeKeyName, alternatingHashAndRangeKeyValues[i + 1]);
        }
        return this.withPrimaryKeys(primaryKeys);
    }

    public TableKeysAndAttributes addPrimaryKey(PrimaryKey primaryKey) {
        if (primaryKey != null) {
            if (this.primaryKeys == null) {
                this.primaryKeys = new ArrayList<PrimaryKey>();
            }
            this.checkConsistency(primaryKey);
            this.primaryKeys.add(primaryKey);
        }
        return this;
    }

    private void checkConsistency(PrimaryKey primaryKey) {
        Set<String> nameSet;
        if (this.primaryKeys.size() > 0 && !(nameSet = this.primaryKeys.get(0).getComponentNameSet()).equals(primaryKey.getComponentNameSet())) {
            throw new IllegalArgumentException("primary key must be added with consistent key attribute name(s)");
        }
    }

    public TableKeysAndAttributes addHashOnlyPrimaryKey(String hashKeyName, Object hashKeyValue) {
        this.addPrimaryKey(new PrimaryKey(hashKeyName, hashKeyValue));
        return this;
    }

    public TableKeysAndAttributes addHashOnlyPrimaryKeys(String hashKeyName, Object ... hashKeyValues) {
        for (Object hashKeyValue : hashKeyValues) {
            this.addPrimaryKey(new PrimaryKey(hashKeyName, hashKeyValue));
        }
        return this;
    }

    public TableKeysAndAttributes addHashAndRangePrimaryKeys(String hashKeyName, String rangeKeyName, Object ... alternatingHashRangeKeyValues) {
        if (alternatingHashRangeKeyValues.length % 2 != 0) {
            throw new IllegalArgumentException("The multiple hash and range key values must alternate");
        }
        for (int i = 0; i < alternatingHashRangeKeyValues.length; i += 2) {
            Object hashKeyValue = alternatingHashRangeKeyValues[i];
            Object rangeKeyValue = alternatingHashRangeKeyValues[i + 1];
            this.addPrimaryKey(new PrimaryKey().addComponent(hashKeyName, hashKeyValue).addComponent(rangeKeyName, rangeKeyValue));
        }
        return this;
    }

    public TableKeysAndAttributes addHashAndRangePrimaryKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        this.addPrimaryKey(new PrimaryKey().addComponent(hashKeyName, hashKeyValue).addComponent(rangeKeyName, rangeKeyValue));
        return this;
    }

    @Deprecated
    public TableKeysAndAttributes withAttrbuteNames(String ... attributeNames) {
        return this.withAttributeNames(attributeNames);
    }

    @Deprecated
    public TableKeysAndAttributes withAttrbuteNames(List<String> attributeNames) {
        return this.withAttributeNames(attributeNames);
    }

    public TableKeysAndAttributes withAttributeNames(String ... attributeNames) {
        this.attributeNames = attributeNames == null ? null : Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(attributeNames)));
        return this;
    }

    public TableKeysAndAttributes withAttributeNames(List<String> attributeNames) {
        this.attributeNames = attributeNames == null ? null : Collections.unmodifiableSet(new LinkedHashSet<String>(attributeNames));
        return this;
    }

    public Set<String> getAttributeNames() {
        return this.attributeNames;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isConsistentRead() {
        return this.consistentRead;
    }

    public TableKeysAndAttributes withConsistentRead(boolean consistentRead) {
        this.consistentRead = consistentRead;
        return this;
    }

    public String getProjectionExpression() {
        return this.projectionExpression;
    }

    public TableKeysAndAttributes withProjectionExpression(String projectionExpression) {
        this.projectionExpression = projectionExpression;
        return this;
    }

    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    public TableKeysAndAttributes withNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, String>(nameMap));
        return this;
    }
}

