/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.spec;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;

class AbstractSpec<T extends AmazonWebServiceRequest> {
    private final T req;

    AbstractSpec(T req) {
        InternalUtils.applyUserAgent(req);
        this.req = req;
    }

    public T getRequest() {
        return this.req;
    }

    public ProgressListener getProgressListener() {
        return this.getRequest().getGeneralProgressListener();
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.getRequest().setGeneralProgressListener(progressListener);
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.getRequest().getRequestMetricCollector();
    }

    public void setRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.getRequest().setRequestMetricCollector(requestMetricCollector);
    }

    public AbstractSpec<T> withProgressListener(ProgressListener progressListener) {
        this.getRequest().setGeneralProgressListener(progressListener);
        return this;
    }

    public AbstractSpec<T> withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.getRequest().setRequestMetricCollector(requestMetricCollector);
        return this;
    }
}

