/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemCollectionMetrics
implements Serializable,
Cloneable {
    private Map<String, AttributeValue> itemCollectionKey;
    private List<Double> sizeEstimateRangeGB;

    public Map<String, AttributeValue> getItemCollectionKey() {
        return this.itemCollectionKey;
    }

    public void setItemCollectionKey(Map<String, AttributeValue> itemCollectionKey) {
        this.itemCollectionKey = itemCollectionKey;
    }

    public ItemCollectionMetrics withItemCollectionKey(Map<String, AttributeValue> itemCollectionKey) {
        this.setItemCollectionKey(itemCollectionKey);
        return this;
    }

    public ItemCollectionMetrics addItemCollectionKeyEntry(String key, AttributeValue value) {
        if (null == this.itemCollectionKey) {
            this.itemCollectionKey = new HashMap<String, AttributeValue>();
        }
        if (this.itemCollectionKey.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.itemCollectionKey.put(key, value);
        return this;
    }

    public ItemCollectionMetrics clearItemCollectionKeyEntries() {
        this.itemCollectionKey = null;
        return this;
    }

    public List<Double> getSizeEstimateRangeGB() {
        return this.sizeEstimateRangeGB;
    }

    public void setSizeEstimateRangeGB(Collection<Double> sizeEstimateRangeGB) {
        if (sizeEstimateRangeGB == null) {
            this.sizeEstimateRangeGB = null;
            return;
        }
        this.sizeEstimateRangeGB = new ArrayList<Double>(sizeEstimateRangeGB);
    }

    public ItemCollectionMetrics withSizeEstimateRangeGB(Double ... sizeEstimateRangeGB) {
        if (this.sizeEstimateRangeGB == null) {
            this.setSizeEstimateRangeGB(new ArrayList<Double>(sizeEstimateRangeGB.length));
        }
        for (Double ele : sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB.add(ele);
        }
        return this;
    }

    public ItemCollectionMetrics withSizeEstimateRangeGB(Collection<Double> sizeEstimateRangeGB) {
        this.setSizeEstimateRangeGB(sizeEstimateRangeGB);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItemCollectionKey() != null) {
            sb.append("ItemCollectionKey: " + this.getItemCollectionKey() + ",");
        }
        if (this.getSizeEstimateRangeGB() != null) {
            sb.append("SizeEstimateRangeGB: " + this.getSizeEstimateRangeGB());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemCollectionMetrics)) {
            return false;
        }
        ItemCollectionMetrics other = (ItemCollectionMetrics)obj;
        if (other.getItemCollectionKey() == null ^ this.getItemCollectionKey() == null) {
            return false;
        }
        if (other.getItemCollectionKey() != null && !other.getItemCollectionKey().equals(this.getItemCollectionKey())) {
            return false;
        }
        if (other.getSizeEstimateRangeGB() == null ^ this.getSizeEstimateRangeGB() == null) {
            return false;
        }
        return other.getSizeEstimateRangeGB() == null || other.getSizeEstimateRangeGB().equals(this.getSizeEstimateRangeGB());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItemCollectionKey() == null ? 0 : this.getItemCollectionKey().hashCode());
        hashCode = 31 * hashCode + (this.getSizeEstimateRangeGB() == null ? 0 : this.getSizeEstimateRangeGB().hashCode());
        return hashCode;
    }

    public ItemCollectionMetrics clone() {
        try {
            return (ItemCollectionMetrics)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

