/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAnnotationRegistry;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratorRegistry;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBReflectionRegistry;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.BooleanToBooleanMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.CustomMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.CustomUnmarshaller;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
final class DynamoDBMappingsRegistry {
    private static final Log log = LogFactory.getLog(DynamoDBMappingsRegistry.class);
    private static final DynamoDBMappingsRegistry INSTANCE = new DynamoDBMappingsRegistry();
    private final ConcurrentMap<Class<?>, Mappings> mappings = new ConcurrentHashMap();
    private final DynamoDBReflectionRegistry reflectionRegistry = new DynamoDBReflectionRegistry();
    private final DynamoDBAnnotationRegistry annotationRegistry = new DynamoDBAnnotationRegistry();
    private final DynamoDBAutoGeneratorRegistry autoGeneratorRegistry = new DynamoDBAutoGeneratorRegistry();

    DynamoDBMappingsRegistry() {
    }

    static final DynamoDBMappingsRegistry instance() {
        return INSTANCE;
    }

    final Mappings mappingsOf(Class<?> clazz) {
        if (!this.mappings.containsKey(clazz)) {
            this.mappings.putIfAbsent(clazz, new Mappings(clazz, this));
        }
        return (Mappings)this.mappings.get(clazz);
    }

    final Mapping mappingOf(Method method) {
        return this.mappingsOf(method.getDeclaringClass()).getMapping(method);
    }

    static final class Mapping {
        private final DynamoDBReflectionRegistry.BeanProperty beanProperty;
        private final DynamoDBAnnotationRegistry.AnnotationMap annotations;
        private final DynamoDBAutoGeneratorRegistry.Generator<Object> autoGenerator;
        private final String attributeName;

        private Mapping(DynamoDBReflectionRegistry.BeanProperty beanProperty, DynamoDBMappingsRegistry registry) {
            this.beanProperty = beanProperty;
            this.annotations = registry.annotationRegistry.annotationsOf(beanProperty.getGetter(), beanProperty.getField());
            this.attributeName = this.annotations.getAttributeName(beanProperty.getFieldName());
            this.autoGenerator = registry.autoGeneratorRegistry.generatorOf(this);
        }

        final Method getter() {
            return this.beanProperty.getGetter();
        }

        final Method setter() {
            return this.beanProperty.getSetter();
        }

        final String getAttributeName() {
            return this.attributeName;
        }

        final Class<?> getGetterType() {
            return this.beanProperty.getGetterType();
        }

        final Object getValueOf(Object target) {
            return this.beanProperty.getValueOf(target);
        }

        final void setValueOf(Object target, Object value) {
            this.beanProperty.setValueOf(target, value);
        }

        final boolean isIgnore() {
            return this.annotations.isIgnore();
        }

        final boolean isPrimaryKey() {
            return this.isHashKey() || this.isRangeKey();
        }

        final boolean isHashKey() {
            return this.annotations.isHashKey();
        }

        final boolean isRangeKey() {
            return this.annotations.isRangeKey();
        }

        final boolean isIndexHashKey() {
            return this.annotations.isIndexHashKey();
        }

        final boolean isIndexRangeKey() {
            return this.annotations.isIndexRangeKey();
        }

        final boolean isVersionAttribute() {
            return this.annotations.isVersionAttribute();
        }

        @Deprecated
        final boolean isVersion() {
            return this.isVersionAttribute();
        }

        final boolean isAutoGeneratedKey() {
            return this.annotations.isAutoGeneratedKey();
        }

        final boolean isAutoGeneratedTimestamp() {
            return this.annotations.isAutoGeneratedTimestamp();
        }

        final DynamoDBAutoGenerateStrategy getAutoGenerateStrategy() {
            return this.annotations.getAutoGenerateStrategy();
        }

        final DynamoDBAutoGeneratorRegistry.Generator<Object> getAutoGenerator() {
            return this.autoGenerator;
        }

        final Collection<String> getGlobalSecondaryIndexNamesOfIndexHashKey() {
            Collection<String> indexNames = this.annotations.getGlobalSecondaryIndexNamesOfIndexHashKey();
            if (indexNames == null) {
                throw new DynamoDBMappingException("@DynamoDBIndexHashKey annotation on getter " + this.getter() + " contains both globalSecondaryIndexName and globalSecondaryIndexNames.");
            }
            if (indexNames.isEmpty()) {
                throw new DynamoDBMappingException("@DynamoDBIndexHashKey annotation on getter " + this.getter() + " doesn't contain any index name.");
            }
            return indexNames;
        }

        final Collection<String> getGlobalSecondaryIndexNamesOfIndexRangeKey() {
            Collection<String> indexNames = this.annotations.getGlobalSecondaryIndexNamesOfIndexRangeKey();
            if (indexNames == null) {
                throw new DynamoDBMappingException("@DynamoDBIndexRangeKey annotation on getter " + this.getter() + " contains both globalSecondaryIndexName and globalSecondaryIndexNames.");
            }
            return indexNames;
        }

        final Collection<String> getLocalSecondaryIndexNamesOfIndexRangeKey() {
            Collection<String> indexNames = this.annotations.getLocalSecondaryIndexNamesOfIndexRangeKey();
            if (indexNames == null) {
                throw new DynamoDBMappingException("@DynamoDBIndexRangeKey annotation on getter " + this.getter() + " contains both localSecondaryIndexName and localSecondaryIndexNames.");
            }
            return indexNames;
        }

        final ArgumentMarshaller getCustomMarshaller() {
            Class<? extends DynamoDBMarshaller<?>> marshallerClass = this.annotations.getMarshallerClass();
            if (marshallerClass != null) {
                return new CustomMarshaller(marshallerClass);
            }
            if (this.annotations.isNativeBoolean()) {
                return BooleanToBooleanMarshaller.instance();
            }
            return null;
        }

        final ArgumentUnmarshaller getCustomUnmarshaller() {
            Class<? extends DynamoDBMarshaller<?>> marshallerClass = this.annotations.getMarshallerClass();
            if (marshallerClass != null) {
                return new CustomUnmarshaller(this.getGetterType(), marshallerClass);
            }
            return null;
        }
    }

    static final class Mappings {
        private final Class<?> objectType;
        private final DynamoDBAnnotationRegistry.AnnotationMap annotations;
        private final Map<String, Mapping> byNames = new HashMap<String, Mapping>();
        private final Map<Method, Mapping> byGetters = new HashMap<Method, Mapping>();
        private final Collection<Mapping> primaryKeys = new HashSet<Mapping>();
        private Mapping hashKey;
        private Mapping rangeKey;
        private Mapping versionAttribute;

        private Mappings(Class<?> clazz, DynamoDBMappingsRegistry registry) {
            this.objectType = clazz;
            this.annotations = registry.annotationRegistry.annotationsOf(clazz);
            for (DynamoDBReflectionRegistry.BeanProperty beanProperty : registry.reflectionRegistry.beanPropertiesOf(clazz)) {
                Mapping mapping;
                DynamoDBAnnotationRegistry.AnnotationMap typeAnnotations;
                if (!this.getObjectType().equals(beanProperty.getGetter().getDeclaringClass()) && !(typeAnnotations = registry.annotationRegistry.annotationsOf(beanProperty.getGetter().getDeclaringClass())).isTable() && !typeAnnotations.isDocument() || (mapping = new Mapping(beanProperty, registry)).isIgnore()) continue;
                if (this.byNames.containsKey(mapping.getAttributeName())) {
                    throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " maps duplicate attributes named " + mapping.getAttributeName());
                }
                this.byNames.put(mapping.getAttributeName(), mapping);
                this.byGetters.put(mapping.getter(), mapping);
                if (mapping.isHashKey()) {
                    if (this.hasHashKey()) {
                        throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " maps @DynamoDBHashKey to multiple attributes");
                    }
                    this.hashKey = mapping;
                    this.primaryKeys.add(mapping);
                }
                if (mapping.isRangeKey()) {
                    if (this.hasRangeKey()) {
                        throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " maps @DynamoDBRangeKey to multiple attributes");
                    }
                    this.rangeKey = mapping;
                    this.primaryKeys.add(mapping);
                }
                if (!mapping.isVersionAttribute()) continue;
                if (this.hasVersionAttribute()) {
                    log.warn((Object)("Class " + this.getObjectType().getName() + " maps @DynamoDBVersionAttribute to multiple attributes"));
                }
                this.versionAttribute = mapping;
            }
            if (this.annotations.isTable() && !this.hasHashKey()) {
                log.warn((Object)("Class " + this.getObjectType().getName() + " does not map a @DynamoDBHashKey attribute"));
            }
        }

        final Class<?> getObjectType() {
            return this.objectType;
        }

        final Collection<Mapping> getMappings() {
            return this.byNames.values();
        }

        final Mapping getMapping(Method method) {
            Mapping mapping = this.byGetters.get(method);
            if (mapping == null) {
                throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " does not map any getter named " + method.getName());
            }
            return mapping;
        }

        final Collection<Mapping> getPrimaryKeys() {
            return this.primaryKeys;
        }

        final boolean hasHashKey() {
            return this.hashKey != null;
        }

        final Mapping getHashKey() {
            if (!this.hasHashKey()) {
                throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " does not map a @DynamoDBHashKey attribute" + "; ensure a public, zero-parameter get method/field is annotated");
            }
            return this.hashKey;
        }

        final boolean hasRangeKey() {
            return this.rangeKey != null;
        }

        final Mapping getRangeKey() {
            return this.rangeKey;
        }

        final boolean hasVersionAttribute() {
            return this.versionAttribute != null;
        }

        final Mapping getVersionAttribute() {
            return this.versionAttribute;
        }

        final boolean isDocument() {
            return this.annotations.isDocument();
        }

        final String getTableName() {
            if (!this.annotations.isTable()) {
                throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " must be annotated with @DynamoDBTable");
            }
            return this.annotations.getTableName();
        }
    }
}

