/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.util.json.JSONWriter;

public class StreamSpecificationJsonMarshaller {
    private static StreamSpecificationJsonMarshaller instance;

    public void marshall(StreamSpecification streamSpecification, JSONWriter jsonWriter) {
        if (streamSpecification == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (streamSpecification.getStreamEnabled() != null) {
                jsonWriter.key("StreamEnabled").value((Object)streamSpecification.getStreamEnabled());
            }
            if (streamSpecification.getStreamViewType() != null) {
                jsonWriter.key("StreamViewType").value((Object)streamSpecification.getStreamViewType());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamSpecificationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamSpecificationJsonMarshaller();
        }
        return instance;
    }
}

