/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.Stream;
import com.amazonaws.util.json.JSONWriter;

public class StreamJsonMarshaller {
    private static StreamJsonMarshaller instance;

    public void marshall(Stream stream, JSONWriter jsonWriter) {
        if (stream == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (stream.getStreamArn() != null) {
                jsonWriter.key("StreamArn").value((Object)stream.getStreamArn());
            }
            if (stream.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)stream.getTableName());
            }
            if (stream.getStreamLabel() != null) {
                jsonWriter.key("StreamLabel").value((Object)stream.getStreamLabel());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamJsonMarshaller();
        }
        return instance;
    }
}

