/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.Capacity;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.transform.CapacityJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class ConsumedCapacityJsonMarshaller {
    private static ConsumedCapacityJsonMarshaller instance;

    public void marshall(ConsumedCapacity consumedCapacity, JSONWriter jsonWriter) {
        if (consumedCapacity == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Capacity> globalSecondaryIndexesMap;
            Map<String, Capacity> localSecondaryIndexesMap;
            jsonWriter.object();
            if (consumedCapacity.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)consumedCapacity.getTableName());
            }
            if (consumedCapacity.getCapacityUnits() != null) {
                jsonWriter.key("CapacityUnits").value((Object)consumedCapacity.getCapacityUnits());
            }
            if (consumedCapacity.getTable() != null) {
                jsonWriter.key("Table");
                CapacityJsonMarshaller.getInstance().marshall(consumedCapacity.getTable(), jsonWriter);
            }
            if ((localSecondaryIndexesMap = consumedCapacity.getLocalSecondaryIndexes()) != null) {
                jsonWriter.key("LocalSecondaryIndexes");
                jsonWriter.object();
                for (Map.Entry<String, Capacity> localSecondaryIndexesMapValue : localSecondaryIndexesMap.entrySet()) {
                    if (localSecondaryIndexesMapValue.getValue() == null) continue;
                    jsonWriter.key(localSecondaryIndexesMapValue.getKey());
                    CapacityJsonMarshaller.getInstance().marshall(localSecondaryIndexesMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if ((globalSecondaryIndexesMap = consumedCapacity.getGlobalSecondaryIndexes()) != null) {
                jsonWriter.key("GlobalSecondaryIndexes");
                jsonWriter.object();
                for (Map.Entry<String, Capacity> globalSecondaryIndexesMapValue : globalSecondaryIndexesMap.entrySet()) {
                    if (globalSecondaryIndexesMapValue.getValue() == null) continue;
                    jsonWriter.key(globalSecondaryIndexesMapValue.getKey());
                    CapacityJsonMarshaller.getInstance().marshall(globalSecondaryIndexesMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConsumedCapacityJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConsumedCapacityJsonMarshaller();
        }
        return instance;
    }
}

