/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers;

import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.LUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class ListUnmarshaller
extends LUnmarshaller {
    private static final ListUnmarshaller INSTANCE = new ListUnmarshaller();
    private final ArgumentUnmarshaller memberUnmarshaller;

    public static ListUnmarshaller instance() {
        return INSTANCE;
    }

    private ListUnmarshaller() {
        this.memberUnmarshaller = null;
    }

    public ListUnmarshaller(ArgumentUnmarshaller memberUnmarshaller) {
        if (memberUnmarshaller == null) {
            throw new NullPointerException("memberUnmarshaller");
        }
        this.memberUnmarshaller = memberUnmarshaller;
    }

    @Override
    public Object unmarshall(AttributeValue value) throws ParseException {
        List<AttributeValue> values = value.getL();
        ArrayList<Object> objects = new ArrayList<Object>(values.size());
        for (AttributeValue v : values) {
            this.memberUnmarshaller.typeCheck(v, null);
            objects.add(this.memberUnmarshaller.unmarshall(v));
        }
        return objects;
    }
}

