/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.drs.model.CPU;

@SdkInternalApi
public class CPUMarshaller {
    private static final MarshallingInfo<Long> CORES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cores").build();
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("modelName").build();
    private static final CPUMarshaller instance = new CPUMarshaller();

    public static CPUMarshaller getInstance() {
        return instance;
    }

    public void marshall(CPU cPU, ProtocolMarshaller protocolMarshaller) {
        if (cPU == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cPU.getCores(), CORES_BINDING);
            protocolMarshaller.marshall((Object)cPU.getModelName(), MODELNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

