/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.drs.model.StartRecoveryRequestSourceServer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartRecoveryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Boolean isDrill;
    private List<StartRecoveryRequestSourceServer> sourceServers;
    private Map<String, String> tags;

    public void setIsDrill(Boolean isDrill) {
        this.isDrill = isDrill;
    }

    public Boolean getIsDrill() {
        return this.isDrill;
    }

    public StartRecoveryRequest withIsDrill(Boolean isDrill) {
        this.setIsDrill(isDrill);
        return this;
    }

    public Boolean isDrill() {
        return this.isDrill;
    }

    public List<StartRecoveryRequestSourceServer> getSourceServers() {
        return this.sourceServers;
    }

    public void setSourceServers(Collection<StartRecoveryRequestSourceServer> sourceServers) {
        if (sourceServers == null) {
            this.sourceServers = null;
            return;
        }
        this.sourceServers = new ArrayList<StartRecoveryRequestSourceServer>(sourceServers);
    }

    public StartRecoveryRequest withSourceServers(StartRecoveryRequestSourceServer ... sourceServers) {
        if (this.sourceServers == null) {
            this.setSourceServers(new ArrayList<StartRecoveryRequestSourceServer>(sourceServers.length));
        }
        for (StartRecoveryRequestSourceServer ele : sourceServers) {
            this.sourceServers.add(ele);
        }
        return this;
    }

    public StartRecoveryRequest withSourceServers(Collection<StartRecoveryRequestSourceServer> sourceServers) {
        this.setSourceServers(sourceServers);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public StartRecoveryRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public StartRecoveryRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public StartRecoveryRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIsDrill() != null) {
            sb.append("IsDrill: ").append(this.getIsDrill()).append(",");
        }
        if (this.getSourceServers() != null) {
            sb.append("SourceServers: ").append(this.getSourceServers()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRecoveryRequest)) {
            return false;
        }
        StartRecoveryRequest other = (StartRecoveryRequest)obj;
        if (other.getIsDrill() == null ^ this.getIsDrill() == null) {
            return false;
        }
        if (other.getIsDrill() != null && !other.getIsDrill().equals(this.getIsDrill())) {
            return false;
        }
        if (other.getSourceServers() == null ^ this.getSourceServers() == null) {
            return false;
        }
        if (other.getSourceServers() != null && !other.getSourceServers().equals(this.getSourceServers())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIsDrill() == null ? 0 : this.getIsDrill().hashCode());
        hashCode = 31 * hashCode + (this.getSourceServers() == null ? 0 : this.getSourceServers().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public StartRecoveryRequest clone() {
        return (StartRecoveryRequest)super.clone();
    }
}

