/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.docdb.model.ModifyDBInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyDBInstanceRequestMarshaller
implements Marshaller<Request<ModifyDBInstanceRequest>, ModifyDBInstanceRequest> {
    public Request<ModifyDBInstanceRequest> marshall(ModifyDBInstanceRequest modifyDBInstanceRequest) {
        if (modifyDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBInstanceRequest, "AmazonDocDB");
        request.addParameter("Action", "ModifyDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBInstanceRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)modifyDBInstanceRequest.getDBInstanceIdentifier()));
        }
        if (modifyDBInstanceRequest.getDBInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)modifyDBInstanceRequest.getDBInstanceClass()));
        }
        if (modifyDBInstanceRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getApplyImmediately()));
        }
        if (modifyDBInstanceRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyDBInstanceRequest.getPreferredMaintenanceWindow()));
        }
        if (modifyDBInstanceRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyDBInstanceRequest.getAutoMinorVersionUpgrade()));
        }
        if (modifyDBInstanceRequest.getNewDBInstanceIdentifier() != null) {
            request.addParameter("NewDBInstanceIdentifier", StringUtils.fromString((String)modifyDBInstanceRequest.getNewDBInstanceIdentifier()));
        }
        if (modifyDBInstanceRequest.getCACertificateIdentifier() != null) {
            request.addParameter("CACertificateIdentifier", StringUtils.fromString((String)modifyDBInstanceRequest.getCACertificateIdentifier()));
        }
        if (modifyDBInstanceRequest.getPromotionTier() != null) {
            request.addParameter("PromotionTier", StringUtils.fromInteger((Integer)modifyDBInstanceRequest.getPromotionTier()));
        }
        return request;
    }
}

