/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.docdb.model.CloudwatchLogsExportConfiguration;
import com.amazonaws.services.docdb.model.ModifyDBClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyDBClusterRequestMarshaller
implements Marshaller<Request<ModifyDBClusterRequest>, ModifyDBClusterRequest> {
    public Request<ModifyDBClusterRequest> marshall(ModifyDBClusterRequest modifyDBClusterRequest) {
        CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;
        if (modifyDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBClusterRequest, "AmazonDocDB");
        request.addParameter("Action", "ModifyDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBClusterRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)modifyDBClusterRequest.getDBClusterIdentifier()));
        }
        if (modifyDBClusterRequest.getNewDBClusterIdentifier() != null) {
            request.addParameter("NewDBClusterIdentifier", StringUtils.fromString((String)modifyDBClusterRequest.getNewDBClusterIdentifier()));
        }
        if (modifyDBClusterRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getApplyImmediately()));
        }
        if (modifyDBClusterRequest.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)modifyDBClusterRequest.getBackupRetentionPeriod()));
        }
        if (modifyDBClusterRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)modifyDBClusterRequest.getDBClusterParameterGroupName()));
        }
        if (modifyDBClusterRequest.getVpcSecurityGroupIds() != null) {
            List<String> vpcSecurityGroupIdsList = modifyDBClusterRequest.getVpcSecurityGroupIds();
            if (vpcSecurityGroupIdsList.isEmpty()) {
                request.addParameter("VpcSecurityGroupIds", "");
            } else {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            }
        }
        if (modifyDBClusterRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)modifyDBClusterRequest.getPort()));
        }
        if (modifyDBClusterRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)modifyDBClusterRequest.getMasterUserPassword()));
        }
        if (modifyDBClusterRequest.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)modifyDBClusterRequest.getPreferredBackupWindow()));
        }
        if (modifyDBClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyDBClusterRequest.getPreferredMaintenanceWindow()));
        }
        if ((cloudwatchLogsExportConfiguration = modifyDBClusterRequest.getCloudwatchLogsExportConfiguration()) != null) {
            if (cloudwatchLogsExportConfiguration.getEnableLogTypes() != null) {
                List<String> enableLogTypesList = cloudwatchLogsExportConfiguration.getEnableLogTypes();
                if (enableLogTypesList.isEmpty()) {
                    request.addParameter("CloudwatchLogsExportConfiguration.EnableLogTypes", "");
                } else {
                    int enableLogTypesListIndex = 1;
                    for (String enableLogTypesListValue : enableLogTypesList) {
                        if (enableLogTypesListValue != null) {
                            request.addParameter("CloudwatchLogsExportConfiguration.EnableLogTypes.member." + enableLogTypesListIndex, StringUtils.fromString((String)enableLogTypesListValue));
                        }
                        ++enableLogTypesListIndex;
                    }
                }
            }
            if (cloudwatchLogsExportConfiguration.getDisableLogTypes() != null) {
                List<String> disableLogTypesList = cloudwatchLogsExportConfiguration.getDisableLogTypes();
                if (disableLogTypesList.isEmpty()) {
                    request.addParameter("CloudwatchLogsExportConfiguration.DisableLogTypes", "");
                } else {
                    int disableLogTypesListIndex = 1;
                    for (String disableLogTypesListValue : disableLogTypesList) {
                        if (disableLogTypesListValue != null) {
                            request.addParameter("CloudwatchLogsExportConfiguration.DisableLogTypes.member." + disableLogTypesListIndex, StringUtils.fromString((String)disableLogTypesListValue));
                        }
                        ++disableLogTypesListIndex;
                    }
                }
            }
        }
        if (modifyDBClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyDBClusterRequest.getEngineVersion()));
        }
        if (modifyDBClusterRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getDeletionProtection()));
        }
        return request;
    }
}

