/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.docdb.model.DescribeGlobalClustersRequest;
import com.amazonaws.services.docdb.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeGlobalClustersRequestMarshaller
implements Marshaller<Request<DescribeGlobalClustersRequest>, DescribeGlobalClustersRequest> {
    public Request<DescribeGlobalClustersRequest> marshall(DescribeGlobalClustersRequest describeGlobalClustersRequest) {
        if (describeGlobalClustersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeGlobalClustersRequest, "AmazonDocDB");
        request.addParameter("Action", "DescribeGlobalClusters");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeGlobalClustersRequest.getGlobalClusterIdentifier() != null) {
            request.addParameter("GlobalClusterIdentifier", StringUtils.fromString((String)describeGlobalClustersRequest.getGlobalClusterIdentifier()));
        }
        if (describeGlobalClustersRequest.getFilters() != null) {
            List<Filter> filtersList = describeGlobalClustersRequest.getFilters();
            if (filtersList.isEmpty()) {
                request.addParameter("Filters", "");
            } else {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    if (filtersListValue != null) {
                        if (filtersListValue.getName() != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                        }
                        if (filtersListValue.getValues() != null) {
                            List<String> valuesList = filtersListValue.getValues();
                            if (valuesList.isEmpty()) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                            } else {
                                int valuesListIndex = 1;
                                for (String valuesListValue : valuesList) {
                                    if (valuesListValue != null) {
                                        request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                    }
                                    ++valuesListIndex;
                                }
                            }
                        }
                    }
                    ++filtersListIndex;
                }
            }
        }
        if (describeGlobalClustersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeGlobalClustersRequest.getMaxRecords()));
        }
        if (describeGlobalClustersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeGlobalClustersRequest.getMarker()));
        }
        return request;
    }
}

