/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.databasemigrationservice.model.DataProviderDescriptor;
import com.amazonaws.services.databasemigrationservice.model.SCApplicationAttributes;
import com.amazonaws.services.databasemigrationservice.model.transform.MigrationProjectMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class MigrationProject
implements Serializable,
Cloneable,
StructuredPojo {
    private String migrationProjectName;
    private String migrationProjectArn;
    private Date migrationProjectCreationTime;
    private List<DataProviderDescriptor> sourceDataProviderDescriptors;
    private List<DataProviderDescriptor> targetDataProviderDescriptors;
    private String instanceProfileArn;
    private String instanceProfileName;
    private String transformationRules;
    private String description;
    private SCApplicationAttributes schemaConversionApplicationAttributes;

    public void setMigrationProjectName(String migrationProjectName) {
        this.migrationProjectName = migrationProjectName;
    }

    public String getMigrationProjectName() {
        return this.migrationProjectName;
    }

    public MigrationProject withMigrationProjectName(String migrationProjectName) {
        this.setMigrationProjectName(migrationProjectName);
        return this;
    }

    public void setMigrationProjectArn(String migrationProjectArn) {
        this.migrationProjectArn = migrationProjectArn;
    }

    public String getMigrationProjectArn() {
        return this.migrationProjectArn;
    }

    public MigrationProject withMigrationProjectArn(String migrationProjectArn) {
        this.setMigrationProjectArn(migrationProjectArn);
        return this;
    }

    public void setMigrationProjectCreationTime(Date migrationProjectCreationTime) {
        this.migrationProjectCreationTime = migrationProjectCreationTime;
    }

    public Date getMigrationProjectCreationTime() {
        return this.migrationProjectCreationTime;
    }

    public MigrationProject withMigrationProjectCreationTime(Date migrationProjectCreationTime) {
        this.setMigrationProjectCreationTime(migrationProjectCreationTime);
        return this;
    }

    public List<DataProviderDescriptor> getSourceDataProviderDescriptors() {
        return this.sourceDataProviderDescriptors;
    }

    public void setSourceDataProviderDescriptors(Collection<DataProviderDescriptor> sourceDataProviderDescriptors) {
        if (sourceDataProviderDescriptors == null) {
            this.sourceDataProviderDescriptors = null;
            return;
        }
        this.sourceDataProviderDescriptors = new ArrayList<DataProviderDescriptor>(sourceDataProviderDescriptors);
    }

    public MigrationProject withSourceDataProviderDescriptors(DataProviderDescriptor ... sourceDataProviderDescriptors) {
        if (this.sourceDataProviderDescriptors == null) {
            this.setSourceDataProviderDescriptors(new ArrayList<DataProviderDescriptor>(sourceDataProviderDescriptors.length));
        }
        for (DataProviderDescriptor ele : sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors.add(ele);
        }
        return this;
    }

    public MigrationProject withSourceDataProviderDescriptors(Collection<DataProviderDescriptor> sourceDataProviderDescriptors) {
        this.setSourceDataProviderDescriptors(sourceDataProviderDescriptors);
        return this;
    }

    public List<DataProviderDescriptor> getTargetDataProviderDescriptors() {
        return this.targetDataProviderDescriptors;
    }

    public void setTargetDataProviderDescriptors(Collection<DataProviderDescriptor> targetDataProviderDescriptors) {
        if (targetDataProviderDescriptors == null) {
            this.targetDataProviderDescriptors = null;
            return;
        }
        this.targetDataProviderDescriptors = new ArrayList<DataProviderDescriptor>(targetDataProviderDescriptors);
    }

    public MigrationProject withTargetDataProviderDescriptors(DataProviderDescriptor ... targetDataProviderDescriptors) {
        if (this.targetDataProviderDescriptors == null) {
            this.setTargetDataProviderDescriptors(new ArrayList<DataProviderDescriptor>(targetDataProviderDescriptors.length));
        }
        for (DataProviderDescriptor ele : targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors.add(ele);
        }
        return this;
    }

    public MigrationProject withTargetDataProviderDescriptors(Collection<DataProviderDescriptor> targetDataProviderDescriptors) {
        this.setTargetDataProviderDescriptors(targetDataProviderDescriptors);
        return this;
    }

    public void setInstanceProfileArn(String instanceProfileArn) {
        this.instanceProfileArn = instanceProfileArn;
    }

    public String getInstanceProfileArn() {
        return this.instanceProfileArn;
    }

    public MigrationProject withInstanceProfileArn(String instanceProfileArn) {
        this.setInstanceProfileArn(instanceProfileArn);
        return this;
    }

    public void setInstanceProfileName(String instanceProfileName) {
        this.instanceProfileName = instanceProfileName;
    }

    public String getInstanceProfileName() {
        return this.instanceProfileName;
    }

    public MigrationProject withInstanceProfileName(String instanceProfileName) {
        this.setInstanceProfileName(instanceProfileName);
        return this;
    }

    public void setTransformationRules(String transformationRules) {
        this.transformationRules = transformationRules;
    }

    public String getTransformationRules() {
        return this.transformationRules;
    }

    public MigrationProject withTransformationRules(String transformationRules) {
        this.setTransformationRules(transformationRules);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public MigrationProject withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSchemaConversionApplicationAttributes(SCApplicationAttributes schemaConversionApplicationAttributes) {
        this.schemaConversionApplicationAttributes = schemaConversionApplicationAttributes;
    }

    public SCApplicationAttributes getSchemaConversionApplicationAttributes() {
        return this.schemaConversionApplicationAttributes;
    }

    public MigrationProject withSchemaConversionApplicationAttributes(SCApplicationAttributes schemaConversionApplicationAttributes) {
        this.setSchemaConversionApplicationAttributes(schemaConversionApplicationAttributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMigrationProjectName() != null) {
            sb.append("MigrationProjectName: ").append(this.getMigrationProjectName()).append(",");
        }
        if (this.getMigrationProjectArn() != null) {
            sb.append("MigrationProjectArn: ").append(this.getMigrationProjectArn()).append(",");
        }
        if (this.getMigrationProjectCreationTime() != null) {
            sb.append("MigrationProjectCreationTime: ").append(this.getMigrationProjectCreationTime()).append(",");
        }
        if (this.getSourceDataProviderDescriptors() != null) {
            sb.append("SourceDataProviderDescriptors: ").append(this.getSourceDataProviderDescriptors()).append(",");
        }
        if (this.getTargetDataProviderDescriptors() != null) {
            sb.append("TargetDataProviderDescriptors: ").append(this.getTargetDataProviderDescriptors()).append(",");
        }
        if (this.getInstanceProfileArn() != null) {
            sb.append("InstanceProfileArn: ").append(this.getInstanceProfileArn()).append(",");
        }
        if (this.getInstanceProfileName() != null) {
            sb.append("InstanceProfileName: ").append(this.getInstanceProfileName()).append(",");
        }
        if (this.getTransformationRules() != null) {
            sb.append("TransformationRules: ").append(this.getTransformationRules()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSchemaConversionApplicationAttributes() != null) {
            sb.append("SchemaConversionApplicationAttributes: ").append(this.getSchemaConversionApplicationAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationProject)) {
            return false;
        }
        MigrationProject other = (MigrationProject)obj;
        if (other.getMigrationProjectName() == null ^ this.getMigrationProjectName() == null) {
            return false;
        }
        if (other.getMigrationProjectName() != null && !other.getMigrationProjectName().equals(this.getMigrationProjectName())) {
            return false;
        }
        if (other.getMigrationProjectArn() == null ^ this.getMigrationProjectArn() == null) {
            return false;
        }
        if (other.getMigrationProjectArn() != null && !other.getMigrationProjectArn().equals(this.getMigrationProjectArn())) {
            return false;
        }
        if (other.getMigrationProjectCreationTime() == null ^ this.getMigrationProjectCreationTime() == null) {
            return false;
        }
        if (other.getMigrationProjectCreationTime() != null && !other.getMigrationProjectCreationTime().equals(this.getMigrationProjectCreationTime())) {
            return false;
        }
        if (other.getSourceDataProviderDescriptors() == null ^ this.getSourceDataProviderDescriptors() == null) {
            return false;
        }
        if (other.getSourceDataProviderDescriptors() != null && !other.getSourceDataProviderDescriptors().equals(this.getSourceDataProviderDescriptors())) {
            return false;
        }
        if (other.getTargetDataProviderDescriptors() == null ^ this.getTargetDataProviderDescriptors() == null) {
            return false;
        }
        if (other.getTargetDataProviderDescriptors() != null && !other.getTargetDataProviderDescriptors().equals(this.getTargetDataProviderDescriptors())) {
            return false;
        }
        if (other.getInstanceProfileArn() == null ^ this.getInstanceProfileArn() == null) {
            return false;
        }
        if (other.getInstanceProfileArn() != null && !other.getInstanceProfileArn().equals(this.getInstanceProfileArn())) {
            return false;
        }
        if (other.getInstanceProfileName() == null ^ this.getInstanceProfileName() == null) {
            return false;
        }
        if (other.getInstanceProfileName() != null && !other.getInstanceProfileName().equals(this.getInstanceProfileName())) {
            return false;
        }
        if (other.getTransformationRules() == null ^ this.getTransformationRules() == null) {
            return false;
        }
        if (other.getTransformationRules() != null && !other.getTransformationRules().equals(this.getTransformationRules())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSchemaConversionApplicationAttributes() == null ^ this.getSchemaConversionApplicationAttributes() == null) {
            return false;
        }
        return other.getSchemaConversionApplicationAttributes() == null || other.getSchemaConversionApplicationAttributes().equals(this.getSchemaConversionApplicationAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMigrationProjectName() == null ? 0 : this.getMigrationProjectName().hashCode());
        hashCode = 31 * hashCode + (this.getMigrationProjectArn() == null ? 0 : this.getMigrationProjectArn().hashCode());
        hashCode = 31 * hashCode + (this.getMigrationProjectCreationTime() == null ? 0 : this.getMigrationProjectCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDataProviderDescriptors() == null ? 0 : this.getSourceDataProviderDescriptors().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDataProviderDescriptors() == null ? 0 : this.getTargetDataProviderDescriptors().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfileArn() == null ? 0 : this.getInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfileName() == null ? 0 : this.getInstanceProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getTransformationRules() == null ? 0 : this.getTransformationRules().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaConversionApplicationAttributes() == null ? 0 : this.getSchemaConversionApplicationAttributes().hashCode());
        return hashCode;
    }

    public MigrationProject clone() {
        try {
            return (MigrationProject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MigrationProjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

