/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>Directory Service</fullname>
 * <p>
 * Directory Service is a web service that makes it easy for you to setup and run directories in the Amazon Web Services
 * cloud, or connect your Amazon Web Services resources with an existing self-managed Microsoft Active Directory. This
 * guide provides detailed information about Directory Service operations, data types, parameters, and errors. For
 * information about Directory Services features, see <a href="https://aws.amazon.com/directoryservice/">Directory
 * Service</a> and the <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/what_is.html">Directory
 * Service Administration Guide</a>.
 * </p>
 * <note>
 * <p>
 * Amazon Web Services provides SDKs that consist of libraries and sample code for various programming languages and
 * platforms (Java, Ruby, .Net, iOS, Android, etc.). The SDKs provide a convenient way to create programmatic access to
 * Directory Service and other Amazon Web Services services. For more information about the Amazon Web Services SDKs,
 * including how to download and install them, see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web
 * Services</a>.
 * </p>
 * </note>
 */
package com.amazonaws.services.directory;

