/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.ResourceTag;
import com.amazonaws.services.directconnect.model.Tag;
import com.amazonaws.services.directconnect.model.transform.TagJsonMarshaller;

public class ResourceTagJsonMarshaller {
    private static ResourceTagJsonMarshaller instance;

    public void marshall(ResourceTag resourceTag, StructuredJsonGenerator jsonGenerator) {
        if (resourceTag == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList tagsList;
            jsonGenerator.writeStartObject();
            if (resourceTag.getResourceArn() != null) {
                jsonGenerator.writeFieldName("resourceArn").writeValue(resourceTag.getResourceArn());
            }
            if (!(tagsList = (SdkInternalList)resourceTag.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceTagJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceTagJsonMarshaller();
        }
        return instance;
    }
}

