/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directconnect.model.CreateInterconnectRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateInterconnectRequestMarshaller
implements Marshaller<Request<CreateInterconnectRequest>, CreateInterconnectRequest> {
    public Request<CreateInterconnectRequest> marshall(CreateInterconnectRequest createInterconnectRequest) {
        if (createInterconnectRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInterconnectRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.CreateInterconnect");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createInterconnectRequest.getInterconnectName() != null) {
                jsonGenerator.writeFieldName("interconnectName").writeValue(createInterconnectRequest.getInterconnectName());
            }
            if (createInterconnectRequest.getBandwidth() != null) {
                jsonGenerator.writeFieldName("bandwidth").writeValue(createInterconnectRequest.getBandwidth());
            }
            if (createInterconnectRequest.getLocation() != null) {
                jsonGenerator.writeFieldName("location").writeValue(createInterconnectRequest.getLocation());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

