/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.NewPublicVirtualInterface;
import com.amazonaws.services.directconnect.model.RouteFilterPrefix;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreatePublicVirtualInterfaceRequestMarshaller
implements Marshaller<Request<CreatePublicVirtualInterfaceRequest>, CreatePublicVirtualInterfaceRequest> {
    public Request<CreatePublicVirtualInterfaceRequest> marshall(CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) {
        if (createPublicVirtualInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPublicVirtualInterfaceRequest, "AmazonDirectConnect");
        String target = "OvertureService.CreatePublicVirtualInterface";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            NewPublicVirtualInterface newPublicVirtualInterface;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createPublicVirtualInterfaceRequest.getConnectionId() != null) {
                jsonWriter.key("connectionId").value((Object)createPublicVirtualInterfaceRequest.getConnectionId());
            }
            if ((newPublicVirtualInterface = createPublicVirtualInterfaceRequest.getNewPublicVirtualInterface()) != null) {
                ListWithAutoConstructFlag routeFilterPrefixesList;
                jsonWriter.key("newPublicVirtualInterface");
                jsonWriter.object();
                if (newPublicVirtualInterface.getVirtualInterfaceName() != null) {
                    jsonWriter.key("virtualInterfaceName").value((Object)newPublicVirtualInterface.getVirtualInterfaceName());
                }
                if (newPublicVirtualInterface.getVlan() != null) {
                    jsonWriter.key("vlan").value((Object)newPublicVirtualInterface.getVlan());
                }
                if (newPublicVirtualInterface.getAsn() != null) {
                    jsonWriter.key("asn").value((Object)newPublicVirtualInterface.getAsn());
                }
                if (newPublicVirtualInterface.getAuthKey() != null) {
                    jsonWriter.key("authKey").value((Object)newPublicVirtualInterface.getAuthKey());
                }
                if (newPublicVirtualInterface.getAmazonAddress() != null) {
                    jsonWriter.key("amazonAddress").value((Object)newPublicVirtualInterface.getAmazonAddress());
                }
                if (newPublicVirtualInterface.getCustomerAddress() != null) {
                    jsonWriter.key("customerAddress").value((Object)newPublicVirtualInterface.getCustomerAddress());
                }
                if (!((routeFilterPrefixesList = (ListWithAutoConstructFlag)newPublicVirtualInterface.getRouteFilterPrefixes()) == null || routeFilterPrefixesList.isAutoConstruct() && routeFilterPrefixesList.isEmpty())) {
                    jsonWriter.key("routeFilterPrefixes");
                    jsonWriter.array();
                    for (RouteFilterPrefix routeFilterPrefixesListValue : routeFilterPrefixesList) {
                        if (routeFilterPrefixesListValue == null) continue;
                        jsonWriter.object();
                        if (routeFilterPrefixesListValue.getCidr() != null) {
                            jsonWriter.key("cidr").value((Object)routeFilterPrefixesListValue.getCidr());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

