/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.OfferingTransaction;
import com.amazonaws.services.devicefarm.model.transform.MonetaryAmountJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.OfferingStatusJsonMarshaller;

public class OfferingTransactionJsonMarshaller {
    private static OfferingTransactionJsonMarshaller instance;

    public void marshall(OfferingTransaction offeringTransaction, StructuredJsonGenerator jsonGenerator) {
        if (offeringTransaction == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (offeringTransaction.getOfferingStatus() != null) {
                jsonGenerator.writeFieldName("offeringStatus");
                OfferingStatusJsonMarshaller.getInstance().marshall(offeringTransaction.getOfferingStatus(), jsonGenerator);
            }
            if (offeringTransaction.getTransactionId() != null) {
                jsonGenerator.writeFieldName("transactionId").writeValue(offeringTransaction.getTransactionId());
            }
            if (offeringTransaction.getCreatedOn() != null) {
                jsonGenerator.writeFieldName("createdOn").writeValue(offeringTransaction.getCreatedOn());
            }
            if (offeringTransaction.getCost() != null) {
                jsonGenerator.writeFieldName("cost");
                MonetaryAmountJsonMarshaller.getInstance().marshall(offeringTransaction.getCost(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static OfferingTransactionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new OfferingTransactionJsonMarshaller();
        }
        return instance;
    }
}

