/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Device;
import com.amazonaws.services.devicefarm.model.transform.CPUJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ResolutionJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class DeviceJsonMarshaller {
    private static DeviceJsonMarshaller instance;

    public void marshall(Device device, SdkJsonGenerator jsonGenerator) {
        if (device == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (device.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(device.getArn());
            }
            if (device.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(device.getName());
            }
            if (device.getManufacturer() != null) {
                jsonGenerator.writeFieldName("manufacturer").writeValue(device.getManufacturer());
            }
            if (device.getModel() != null) {
                jsonGenerator.writeFieldName("model").writeValue(device.getModel());
            }
            if (device.getFormFactor() != null) {
                jsonGenerator.writeFieldName("formFactor").writeValue(device.getFormFactor());
            }
            if (device.getPlatform() != null) {
                jsonGenerator.writeFieldName("platform").writeValue(device.getPlatform());
            }
            if (device.getOs() != null) {
                jsonGenerator.writeFieldName("os").writeValue(device.getOs());
            }
            if (device.getCpu() != null) {
                jsonGenerator.writeFieldName("cpu");
                CPUJsonMarshaller.getInstance().marshall(device.getCpu(), jsonGenerator);
            }
            if (device.getResolution() != null) {
                jsonGenerator.writeFieldName("resolution");
                ResolutionJsonMarshaller.getInstance().marshall(device.getResolution(), jsonGenerator);
            }
            if (device.getHeapSize() != null) {
                jsonGenerator.writeFieldName("heapSize").writeValue(device.getHeapSize().longValue());
            }
            if (device.getMemory() != null) {
                jsonGenerator.writeFieldName("memory").writeValue(device.getMemory().longValue());
            }
            if (device.getImage() != null) {
                jsonGenerator.writeFieldName("image").writeValue(device.getImage());
            }
            if (device.getCarrier() != null) {
                jsonGenerator.writeFieldName("carrier").writeValue(device.getCarrier());
            }
            if (device.getRadio() != null) {
                jsonGenerator.writeFieldName("radio").writeValue(device.getRadio());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeviceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeviceJsonMarshaller();
        }
        return instance;
    }
}

