/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Run;
import com.amazonaws.services.devicefarm.model.transform.CountersJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.DeviceMinutesJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class RunJsonMarshaller {
    private static RunJsonMarshaller instance;

    public void marshall(Run run, JSONWriter jsonWriter) {
        if (run == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (run.getArn() != null) {
                jsonWriter.key("arn").value((Object)run.getArn());
            }
            if (run.getName() != null) {
                jsonWriter.key("name").value((Object)run.getName());
            }
            if (run.getType() != null) {
                jsonWriter.key("type").value((Object)run.getType());
            }
            if (run.getPlatform() != null) {
                jsonWriter.key("platform").value((Object)run.getPlatform());
            }
            if (run.getCreated() != null) {
                jsonWriter.key("created").value(run.getCreated());
            }
            if (run.getStatus() != null) {
                jsonWriter.key("status").value((Object)run.getStatus());
            }
            if (run.getResult() != null) {
                jsonWriter.key("result").value((Object)run.getResult());
            }
            if (run.getStarted() != null) {
                jsonWriter.key("started").value(run.getStarted());
            }
            if (run.getStopped() != null) {
                jsonWriter.key("stopped").value(run.getStopped());
            }
            if (run.getCounters() != null) {
                jsonWriter.key("counters");
                CountersJsonMarshaller.getInstance().marshall(run.getCounters(), jsonWriter);
            }
            if (run.getMessage() != null) {
                jsonWriter.key("message").value((Object)run.getMessage());
            }
            if (run.getTotalJobs() != null) {
                jsonWriter.key("totalJobs").value((Object)run.getTotalJobs());
            }
            if (run.getCompletedJobs() != null) {
                jsonWriter.key("completedJobs").value((Object)run.getCompletedJobs());
            }
            if (run.getBillingMethod() != null) {
                jsonWriter.key("billingMethod").value((Object)run.getBillingMethod());
            }
            if (run.getDeviceMinutes() != null) {
                jsonWriter.key("deviceMinutes");
                DeviceMinutesJsonMarshaller.getInstance().marshall(run.getDeviceMinutes(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RunJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RunJsonMarshaller();
        }
        return instance;
    }
}

