/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Job;
import com.amazonaws.services.devicefarm.model.transform.CountersJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.DeviceJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.DeviceMinutesJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class JobJsonMarshaller {
    private static JobJsonMarshaller instance;

    public void marshall(Job job, JSONWriter jsonWriter) {
        if (job == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (job.getArn() != null) {
                jsonWriter.key("arn").value((Object)job.getArn());
            }
            if (job.getName() != null) {
                jsonWriter.key("name").value((Object)job.getName());
            }
            if (job.getType() != null) {
                jsonWriter.key("type").value((Object)job.getType());
            }
            if (job.getCreated() != null) {
                jsonWriter.key("created").value(job.getCreated());
            }
            if (job.getStatus() != null) {
                jsonWriter.key("status").value((Object)job.getStatus());
            }
            if (job.getResult() != null) {
                jsonWriter.key("result").value((Object)job.getResult());
            }
            if (job.getStarted() != null) {
                jsonWriter.key("started").value(job.getStarted());
            }
            if (job.getStopped() != null) {
                jsonWriter.key("stopped").value(job.getStopped());
            }
            if (job.getCounters() != null) {
                jsonWriter.key("counters");
                CountersJsonMarshaller.getInstance().marshall(job.getCounters(), jsonWriter);
            }
            if (job.getMessage() != null) {
                jsonWriter.key("message").value((Object)job.getMessage());
            }
            if (job.getDevice() != null) {
                jsonWriter.key("device");
                DeviceJsonMarshaller.getInstance().marshall(job.getDevice(), jsonWriter);
            }
            if (job.getDeviceMinutes() != null) {
                jsonWriter.key("deviceMinutes");
                DeviceMinutesJsonMarshaller.getInstance().marshall(job.getDeviceMinutes(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobJsonMarshaller();
        }
        return instance;
    }
}

