/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.CpuArchitectureType;
import com.amazonaws.services.deadline.model.Ec2EbsVolume;
import com.amazonaws.services.deadline.model.FleetAmountCapability;
import com.amazonaws.services.deadline.model.FleetAttributeCapability;
import com.amazonaws.services.deadline.model.MemoryMiBRange;
import com.amazonaws.services.deadline.model.ServiceManagedFleetOperatingSystemFamily;
import com.amazonaws.services.deadline.model.VCpuCountRange;
import com.amazonaws.services.deadline.model.transform.ServiceManagedEc2InstanceCapabilitiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceManagedEc2InstanceCapabilities
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> allowedInstanceTypes;
    private String cpuArchitectureType;
    private List<FleetAmountCapability> customAmounts;
    private List<FleetAttributeCapability> customAttributes;
    private List<String> excludedInstanceTypes;
    private MemoryMiBRange memoryMiB;
    private String osFamily;
    private Ec2EbsVolume rootEbsVolume;
    private VCpuCountRange vCpuCount;

    public List<String> getAllowedInstanceTypes() {
        return this.allowedInstanceTypes;
    }

    public void setAllowedInstanceTypes(Collection<String> allowedInstanceTypes) {
        if (allowedInstanceTypes == null) {
            this.allowedInstanceTypes = null;
            return;
        }
        this.allowedInstanceTypes = new ArrayList<String>(allowedInstanceTypes);
    }

    public ServiceManagedEc2InstanceCapabilities withAllowedInstanceTypes(String ... allowedInstanceTypes) {
        if (this.allowedInstanceTypes == null) {
            this.setAllowedInstanceTypes(new ArrayList<String>(allowedInstanceTypes.length));
        }
        for (String ele : allowedInstanceTypes) {
            this.allowedInstanceTypes.add(ele);
        }
        return this;
    }

    public ServiceManagedEc2InstanceCapabilities withAllowedInstanceTypes(Collection<String> allowedInstanceTypes) {
        this.setAllowedInstanceTypes(allowedInstanceTypes);
        return this;
    }

    public void setCpuArchitectureType(String cpuArchitectureType) {
        this.cpuArchitectureType = cpuArchitectureType;
    }

    public String getCpuArchitectureType() {
        return this.cpuArchitectureType;
    }

    public ServiceManagedEc2InstanceCapabilities withCpuArchitectureType(String cpuArchitectureType) {
        this.setCpuArchitectureType(cpuArchitectureType);
        return this;
    }

    public ServiceManagedEc2InstanceCapabilities withCpuArchitectureType(CpuArchitectureType cpuArchitectureType) {
        this.cpuArchitectureType = cpuArchitectureType.toString();
        return this;
    }

    public List<FleetAmountCapability> getCustomAmounts() {
        return this.customAmounts;
    }

    public void setCustomAmounts(Collection<FleetAmountCapability> customAmounts) {
        if (customAmounts == null) {
            this.customAmounts = null;
            return;
        }
        this.customAmounts = new ArrayList<FleetAmountCapability>(customAmounts);
    }

    public ServiceManagedEc2InstanceCapabilities withCustomAmounts(FleetAmountCapability ... customAmounts) {
        if (this.customAmounts == null) {
            this.setCustomAmounts(new ArrayList<FleetAmountCapability>(customAmounts.length));
        }
        for (FleetAmountCapability ele : customAmounts) {
            this.customAmounts.add(ele);
        }
        return this;
    }

    public ServiceManagedEc2InstanceCapabilities withCustomAmounts(Collection<FleetAmountCapability> customAmounts) {
        this.setCustomAmounts(customAmounts);
        return this;
    }

    public List<FleetAttributeCapability> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(Collection<FleetAttributeCapability> customAttributes) {
        if (customAttributes == null) {
            this.customAttributes = null;
            return;
        }
        this.customAttributes = new ArrayList<FleetAttributeCapability>(customAttributes);
    }

    public ServiceManagedEc2InstanceCapabilities withCustomAttributes(FleetAttributeCapability ... customAttributes) {
        if (this.customAttributes == null) {
            this.setCustomAttributes(new ArrayList<FleetAttributeCapability>(customAttributes.length));
        }
        for (FleetAttributeCapability ele : customAttributes) {
            this.customAttributes.add(ele);
        }
        return this;
    }

    public ServiceManagedEc2InstanceCapabilities withCustomAttributes(Collection<FleetAttributeCapability> customAttributes) {
        this.setCustomAttributes(customAttributes);
        return this;
    }

    public List<String> getExcludedInstanceTypes() {
        return this.excludedInstanceTypes;
    }

    public void setExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
        if (excludedInstanceTypes == null) {
            this.excludedInstanceTypes = null;
            return;
        }
        this.excludedInstanceTypes = new ArrayList<String>(excludedInstanceTypes);
    }

    public ServiceManagedEc2InstanceCapabilities withExcludedInstanceTypes(String ... excludedInstanceTypes) {
        if (this.excludedInstanceTypes == null) {
            this.setExcludedInstanceTypes(new ArrayList<String>(excludedInstanceTypes.length));
        }
        for (String ele : excludedInstanceTypes) {
            this.excludedInstanceTypes.add(ele);
        }
        return this;
    }

    public ServiceManagedEc2InstanceCapabilities withExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
        this.setExcludedInstanceTypes(excludedInstanceTypes);
        return this;
    }

    public void setMemoryMiB(MemoryMiBRange memoryMiB) {
        this.memoryMiB = memoryMiB;
    }

    public MemoryMiBRange getMemoryMiB() {
        return this.memoryMiB;
    }

    public ServiceManagedEc2InstanceCapabilities withMemoryMiB(MemoryMiBRange memoryMiB) {
        this.setMemoryMiB(memoryMiB);
        return this;
    }

    public void setOsFamily(String osFamily) {
        this.osFamily = osFamily;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public ServiceManagedEc2InstanceCapabilities withOsFamily(String osFamily) {
        this.setOsFamily(osFamily);
        return this;
    }

    public ServiceManagedEc2InstanceCapabilities withOsFamily(ServiceManagedFleetOperatingSystemFamily osFamily) {
        this.osFamily = osFamily.toString();
        return this;
    }

    public void setRootEbsVolume(Ec2EbsVolume rootEbsVolume) {
        this.rootEbsVolume = rootEbsVolume;
    }

    public Ec2EbsVolume getRootEbsVolume() {
        return this.rootEbsVolume;
    }

    public ServiceManagedEc2InstanceCapabilities withRootEbsVolume(Ec2EbsVolume rootEbsVolume) {
        this.setRootEbsVolume(rootEbsVolume);
        return this;
    }

    public void setVCpuCount(VCpuCountRange vCpuCount) {
        this.vCpuCount = vCpuCount;
    }

    public VCpuCountRange getVCpuCount() {
        return this.vCpuCount;
    }

    public ServiceManagedEc2InstanceCapabilities withVCpuCount(VCpuCountRange vCpuCount) {
        this.setVCpuCount(vCpuCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllowedInstanceTypes() != null) {
            sb.append("AllowedInstanceTypes: ").append(this.getAllowedInstanceTypes()).append(",");
        }
        if (this.getCpuArchitectureType() != null) {
            sb.append("CpuArchitectureType: ").append(this.getCpuArchitectureType()).append(",");
        }
        if (this.getCustomAmounts() != null) {
            sb.append("CustomAmounts: ").append(this.getCustomAmounts()).append(",");
        }
        if (this.getCustomAttributes() != null) {
            sb.append("CustomAttributes: ").append(this.getCustomAttributes()).append(",");
        }
        if (this.getExcludedInstanceTypes() != null) {
            sb.append("ExcludedInstanceTypes: ").append(this.getExcludedInstanceTypes()).append(",");
        }
        if (this.getMemoryMiB() != null) {
            sb.append("MemoryMiB: ").append(this.getMemoryMiB()).append(",");
        }
        if (this.getOsFamily() != null) {
            sb.append("OsFamily: ").append(this.getOsFamily()).append(",");
        }
        if (this.getRootEbsVolume() != null) {
            sb.append("RootEbsVolume: ").append(this.getRootEbsVolume()).append(",");
        }
        if (this.getVCpuCount() != null) {
            sb.append("VCpuCount: ").append(this.getVCpuCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceManagedEc2InstanceCapabilities)) {
            return false;
        }
        ServiceManagedEc2InstanceCapabilities other = (ServiceManagedEc2InstanceCapabilities)obj;
        if (other.getAllowedInstanceTypes() == null ^ this.getAllowedInstanceTypes() == null) {
            return false;
        }
        if (other.getAllowedInstanceTypes() != null && !other.getAllowedInstanceTypes().equals(this.getAllowedInstanceTypes())) {
            return false;
        }
        if (other.getCpuArchitectureType() == null ^ this.getCpuArchitectureType() == null) {
            return false;
        }
        if (other.getCpuArchitectureType() != null && !other.getCpuArchitectureType().equals(this.getCpuArchitectureType())) {
            return false;
        }
        if (other.getCustomAmounts() == null ^ this.getCustomAmounts() == null) {
            return false;
        }
        if (other.getCustomAmounts() != null && !other.getCustomAmounts().equals(this.getCustomAmounts())) {
            return false;
        }
        if (other.getCustomAttributes() == null ^ this.getCustomAttributes() == null) {
            return false;
        }
        if (other.getCustomAttributes() != null && !other.getCustomAttributes().equals(this.getCustomAttributes())) {
            return false;
        }
        if (other.getExcludedInstanceTypes() == null ^ this.getExcludedInstanceTypes() == null) {
            return false;
        }
        if (other.getExcludedInstanceTypes() != null && !other.getExcludedInstanceTypes().equals(this.getExcludedInstanceTypes())) {
            return false;
        }
        if (other.getMemoryMiB() == null ^ this.getMemoryMiB() == null) {
            return false;
        }
        if (other.getMemoryMiB() != null && !other.getMemoryMiB().equals(this.getMemoryMiB())) {
            return false;
        }
        if (other.getOsFamily() == null ^ this.getOsFamily() == null) {
            return false;
        }
        if (other.getOsFamily() != null && !other.getOsFamily().equals(this.getOsFamily())) {
            return false;
        }
        if (other.getRootEbsVolume() == null ^ this.getRootEbsVolume() == null) {
            return false;
        }
        if (other.getRootEbsVolume() != null && !other.getRootEbsVolume().equals(this.getRootEbsVolume())) {
            return false;
        }
        if (other.getVCpuCount() == null ^ this.getVCpuCount() == null) {
            return false;
        }
        return other.getVCpuCount() == null || other.getVCpuCount().equals(this.getVCpuCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllowedInstanceTypes() == null ? 0 : this.getAllowedInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getCpuArchitectureType() == null ? 0 : this.getCpuArchitectureType().hashCode());
        hashCode = 31 * hashCode + (this.getCustomAmounts() == null ? 0 : this.getCustomAmounts().hashCode());
        hashCode = 31 * hashCode + (this.getCustomAttributes() == null ? 0 : this.getCustomAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getExcludedInstanceTypes() == null ? 0 : this.getExcludedInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getMemoryMiB() == null ? 0 : this.getMemoryMiB().hashCode());
        hashCode = 31 * hashCode + (this.getOsFamily() == null ? 0 : this.getOsFamily().hashCode());
        hashCode = 31 * hashCode + (this.getRootEbsVolume() == null ? 0 : this.getRootEbsVolume().hashCode());
        hashCode = 31 * hashCode + (this.getVCpuCount() == null ? 0 : this.getVCpuCount().hashCode());
        return hashCode;
    }

    public ServiceManagedEc2InstanceCapabilities clone() {
        try {
            return (ServiceManagedEc2InstanceCapabilities)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceManagedEc2InstanceCapabilitiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

