/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.deadline.model.WorkerSessionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSessionsForWorkerResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<WorkerSessionSummary> sessions;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSessionsForWorkerResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<WorkerSessionSummary> getSessions() {
        return this.sessions;
    }

    public void setSessions(Collection<WorkerSessionSummary> sessions) {
        if (sessions == null) {
            this.sessions = null;
            return;
        }
        this.sessions = new ArrayList<WorkerSessionSummary>(sessions);
    }

    public ListSessionsForWorkerResult withSessions(WorkerSessionSummary ... sessions) {
        if (this.sessions == null) {
            this.setSessions(new ArrayList<WorkerSessionSummary>(sessions.length));
        }
        for (WorkerSessionSummary ele : sessions) {
            this.sessions.add(ele);
        }
        return this;
    }

    public ListSessionsForWorkerResult withSessions(Collection<WorkerSessionSummary> sessions) {
        this.setSessions(sessions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSessions() != null) {
            sb.append("Sessions: ").append(this.getSessions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionsForWorkerResult)) {
            return false;
        }
        ListSessionsForWorkerResult other = (ListSessionsForWorkerResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSessions() == null ^ this.getSessions() == null) {
            return false;
        }
        return other.getSessions() == null || other.getSessions().equals(this.getSessions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSessions() == null ? 0 : this.getSessions().hashCode());
        return hashCode;
    }

    public ListSessionsForWorkerResult clone() {
        try {
            return (ListSessionsForWorkerResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

