/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.deadline.model.FarmSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListFarmsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<FarmSummary> farms;
    private String nextToken;

    public List<FarmSummary> getFarms() {
        return this.farms;
    }

    public void setFarms(Collection<FarmSummary> farms) {
        if (farms == null) {
            this.farms = null;
            return;
        }
        this.farms = new ArrayList<FarmSummary>(farms);
    }

    public ListFarmsResult withFarms(FarmSummary ... farms) {
        if (this.farms == null) {
            this.setFarms(new ArrayList<FarmSummary>(farms.length));
        }
        for (FarmSummary ele : farms) {
            this.farms.add(ele);
        }
        return this;
    }

    public ListFarmsResult withFarms(Collection<FarmSummary> farms) {
        this.setFarms(farms);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFarmsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFarms() != null) {
            sb.append("Farms: ").append(this.getFarms()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFarmsResult)) {
            return false;
        }
        ListFarmsResult other = (ListFarmsResult)obj;
        if (other.getFarms() == null ^ this.getFarms() == null) {
            return false;
        }
        if (other.getFarms() != null && !other.getFarms().equals(this.getFarms())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFarms() == null ? 0 : this.getFarms().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListFarmsResult clone() {
        try {
            return (ListFarmsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

