/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datazone.model.FilterClause;
import com.amazonaws.services.datazone.model.SearchInItem;
import com.amazonaws.services.datazone.model.SearchOutputAdditionalAttribute;
import com.amazonaws.services.datazone.model.SearchSort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchListingsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> additionalAttributes;
    private String domainIdentifier;
    private FilterClause filters;
    private Integer maxResults;
    private String nextToken;
    private List<SearchInItem> searchIn;
    private String searchText;
    private SearchSort sort;

    public List<String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public void setAdditionalAttributes(Collection<String> additionalAttributes) {
        if (additionalAttributes == null) {
            this.additionalAttributes = null;
            return;
        }
        this.additionalAttributes = new ArrayList<String>(additionalAttributes);
    }

    public SearchListingsRequest withAdditionalAttributes(String ... additionalAttributes) {
        if (this.additionalAttributes == null) {
            this.setAdditionalAttributes(new ArrayList<String>(additionalAttributes.length));
        }
        for (String ele : additionalAttributes) {
            this.additionalAttributes.add(ele);
        }
        return this;
    }

    public SearchListingsRequest withAdditionalAttributes(Collection<String> additionalAttributes) {
        this.setAdditionalAttributes(additionalAttributes);
        return this;
    }

    public SearchListingsRequest withAdditionalAttributes(SearchOutputAdditionalAttribute ... additionalAttributes) {
        ArrayList<String> additionalAttributesCopy = new ArrayList<String>(additionalAttributes.length);
        for (SearchOutputAdditionalAttribute value : additionalAttributes) {
            additionalAttributesCopy.add(value.toString());
        }
        if (this.getAdditionalAttributes() == null) {
            this.setAdditionalAttributes(additionalAttributesCopy);
        } else {
            this.getAdditionalAttributes().addAll(additionalAttributesCopy);
        }
        return this;
    }

    public void setDomainIdentifier(String domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public SearchListingsRequest withDomainIdentifier(String domainIdentifier) {
        this.setDomainIdentifier(domainIdentifier);
        return this;
    }

    public void setFilters(FilterClause filters) {
        this.filters = filters;
    }

    public FilterClause getFilters() {
        return this.filters;
    }

    public SearchListingsRequest withFilters(FilterClause filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public SearchListingsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchListingsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<SearchInItem> getSearchIn() {
        return this.searchIn;
    }

    public void setSearchIn(Collection<SearchInItem> searchIn) {
        if (searchIn == null) {
            this.searchIn = null;
            return;
        }
        this.searchIn = new ArrayList<SearchInItem>(searchIn);
    }

    public SearchListingsRequest withSearchIn(SearchInItem ... searchIn) {
        if (this.searchIn == null) {
            this.setSearchIn(new ArrayList<SearchInItem>(searchIn.length));
        }
        for (SearchInItem ele : searchIn) {
            this.searchIn.add(ele);
        }
        return this;
    }

    public SearchListingsRequest withSearchIn(Collection<SearchInItem> searchIn) {
        this.setSearchIn(searchIn);
        return this;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public SearchListingsRequest withSearchText(String searchText) {
        this.setSearchText(searchText);
        return this;
    }

    public void setSort(SearchSort sort) {
        this.sort = sort;
    }

    public SearchSort getSort() {
        return this.sort;
    }

    public SearchListingsRequest withSort(SearchSort sort) {
        this.setSort(sort);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdditionalAttributes() != null) {
            sb.append("AdditionalAttributes: ").append(this.getAdditionalAttributes()).append(",");
        }
        if (this.getDomainIdentifier() != null) {
            sb.append("DomainIdentifier: ").append(this.getDomainIdentifier()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSearchIn() != null) {
            sb.append("SearchIn: ").append(this.getSearchIn()).append(",");
        }
        if (this.getSearchText() != null) {
            sb.append("SearchText: ").append(this.getSearchText()).append(",");
        }
        if (this.getSort() != null) {
            sb.append("Sort: ").append(this.getSort());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchListingsRequest)) {
            return false;
        }
        SearchListingsRequest other = (SearchListingsRequest)obj;
        if (other.getAdditionalAttributes() == null ^ this.getAdditionalAttributes() == null) {
            return false;
        }
        if (other.getAdditionalAttributes() != null && !other.getAdditionalAttributes().equals(this.getAdditionalAttributes())) {
            return false;
        }
        if (other.getDomainIdentifier() == null ^ this.getDomainIdentifier() == null) {
            return false;
        }
        if (other.getDomainIdentifier() != null && !other.getDomainIdentifier().equals(this.getDomainIdentifier())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSearchIn() == null ^ this.getSearchIn() == null) {
            return false;
        }
        if (other.getSearchIn() != null && !other.getSearchIn().equals(this.getSearchIn())) {
            return false;
        }
        if (other.getSearchText() == null ^ this.getSearchText() == null) {
            return false;
        }
        if (other.getSearchText() != null && !other.getSearchText().equals(this.getSearchText())) {
            return false;
        }
        if (other.getSort() == null ^ this.getSort() == null) {
            return false;
        }
        return other.getSort() == null || other.getSort().equals(this.getSort());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdditionalAttributes() == null ? 0 : this.getAdditionalAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getDomainIdentifier() == null ? 0 : this.getDomainIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSearchIn() == null ? 0 : this.getSearchIn().hashCode());
        hashCode = 31 * hashCode + (this.getSearchText() == null ? 0 : this.getSearchText().hashCode());
        hashCode = 31 * hashCode + (this.getSort() == null ? 0 : this.getSort().hashCode());
        return hashCode;
    }

    public SearchListingsRequest clone() {
        return (SearchListingsRequest)super.clone();
    }
}

