/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datazone.model.NotificationType;
import com.amazonaws.services.datazone.model.TaskStatus;
import com.amazonaws.services.datazone.model.Topic;
import com.amazonaws.services.datazone.model.transform.NotificationOutputMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class NotificationOutput
implements Serializable,
Cloneable,
StructuredPojo {
    private String actionLink;
    private Date creationTimestamp;
    private String domainIdentifier;
    private String identifier;
    private Date lastUpdatedTimestamp;
    private String message;
    private Map<String, String> metadata;
    private String status;
    private String title;
    private Topic topic;
    private String type;

    public void setActionLink(String actionLink) {
        this.actionLink = actionLink;
    }

    public String getActionLink() {
        return this.actionLink;
    }

    public NotificationOutput withActionLink(String actionLink) {
        this.setActionLink(actionLink);
        return this;
    }

    public void setCreationTimestamp(Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public NotificationOutput withCreationTimestamp(Date creationTimestamp) {
        this.setCreationTimestamp(creationTimestamp);
        return this;
    }

    public void setDomainIdentifier(String domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public NotificationOutput withDomainIdentifier(String domainIdentifier) {
        this.setDomainIdentifier(domainIdentifier);
        return this;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public NotificationOutput withIdentifier(String identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    public void setLastUpdatedTimestamp(Date lastUpdatedTimestamp) {
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
    }

    public Date getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public NotificationOutput withLastUpdatedTimestamp(Date lastUpdatedTimestamp) {
        this.setLastUpdatedTimestamp(lastUpdatedTimestamp);
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public NotificationOutput withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public NotificationOutput withMetadata(Map<String, String> metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public NotificationOutput addMetadataEntry(String key, String value) {
        if (null == this.metadata) {
            this.metadata = new HashMap<String, String>();
        }
        if (this.metadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metadata.put(key, value);
        return this;
    }

    public NotificationOutput clearMetadataEntries() {
        this.metadata = null;
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public NotificationOutput withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public NotificationOutput withStatus(TaskStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public NotificationOutput withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public NotificationOutput withTopic(Topic topic) {
        this.setTopic(topic);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public NotificationOutput withType(String type) {
        this.setType(type);
        return this;
    }

    public NotificationOutput withType(NotificationType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActionLink() != null) {
            sb.append("ActionLink: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCreationTimestamp() != null) {
            sb.append("CreationTimestamp: ").append(this.getCreationTimestamp()).append(",");
        }
        if (this.getDomainIdentifier() != null) {
            sb.append("DomainIdentifier: ").append(this.getDomainIdentifier()).append(",");
        }
        if (this.getIdentifier() != null) {
            sb.append("Identifier: ").append(this.getIdentifier()).append(",");
        }
        if (this.getLastUpdatedTimestamp() != null) {
            sb.append("LastUpdatedTimestamp: ").append(this.getLastUpdatedTimestamp()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTopic() != null) {
            sb.append("Topic: ").append(this.getTopic()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationOutput)) {
            return false;
        }
        NotificationOutput other = (NotificationOutput)obj;
        if (other.getActionLink() == null ^ this.getActionLink() == null) {
            return false;
        }
        if (other.getActionLink() != null && !other.getActionLink().equals(this.getActionLink())) {
            return false;
        }
        if (other.getCreationTimestamp() == null ^ this.getCreationTimestamp() == null) {
            return false;
        }
        if (other.getCreationTimestamp() != null && !other.getCreationTimestamp().equals(this.getCreationTimestamp())) {
            return false;
        }
        if (other.getDomainIdentifier() == null ^ this.getDomainIdentifier() == null) {
            return false;
        }
        if (other.getDomainIdentifier() != null && !other.getDomainIdentifier().equals(this.getDomainIdentifier())) {
            return false;
        }
        if (other.getIdentifier() == null ^ this.getIdentifier() == null) {
            return false;
        }
        if (other.getIdentifier() != null && !other.getIdentifier().equals(this.getIdentifier())) {
            return false;
        }
        if (other.getLastUpdatedTimestamp() == null ^ this.getLastUpdatedTimestamp() == null) {
            return false;
        }
        if (other.getLastUpdatedTimestamp() != null && !other.getLastUpdatedTimestamp().equals(this.getLastUpdatedTimestamp())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getTopic() == null ^ this.getTopic() == null) {
            return false;
        }
        if (other.getTopic() != null && !other.getTopic().equals(this.getTopic())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActionLink() == null ? 0 : this.getActionLink().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTimestamp() == null ? 0 : this.getCreationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getDomainIdentifier() == null ? 0 : this.getDomainIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTimestamp() == null ? 0 : this.getLastUpdatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getTopic() == null ? 0 : this.getTopic().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public NotificationOutput clone() {
        try {
            return (NotificationOutput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

