/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datazone.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetFilter" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetAssetFilterRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the data asset.
     * </p>
     */
    private String assetIdentifier;
    /**
     * <p>
     * The ID of the domain where you want to get an asset filter.
     * </p>
     */
    private String domainIdentifier;
    /**
     * <p>
     * The ID of the asset filter.
     * </p>
     */
    private String identifier;

    /**
     * <p>
     * The ID of the data asset.
     * </p>
     * 
     * @param assetIdentifier
     *        The ID of the data asset.
     */

    public void setAssetIdentifier(String assetIdentifier) {
        this.assetIdentifier = assetIdentifier;
    }

    /**
     * <p>
     * The ID of the data asset.
     * </p>
     * 
     * @return The ID of the data asset.
     */

    public String getAssetIdentifier() {
        return this.assetIdentifier;
    }

    /**
     * <p>
     * The ID of the data asset.
     * </p>
     * 
     * @param assetIdentifier
     *        The ID of the data asset.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetAssetFilterRequest withAssetIdentifier(String assetIdentifier) {
        setAssetIdentifier(assetIdentifier);
        return this;
    }

    /**
     * <p>
     * The ID of the domain where you want to get an asset filter.
     * </p>
     * 
     * @param domainIdentifier
     *        The ID of the domain where you want to get an asset filter.
     */

    public void setDomainIdentifier(String domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    /**
     * <p>
     * The ID of the domain where you want to get an asset filter.
     * </p>
     * 
     * @return The ID of the domain where you want to get an asset filter.
     */

    public String getDomainIdentifier() {
        return this.domainIdentifier;
    }

    /**
     * <p>
     * The ID of the domain where you want to get an asset filter.
     * </p>
     * 
     * @param domainIdentifier
     *        The ID of the domain where you want to get an asset filter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetAssetFilterRequest withDomainIdentifier(String domainIdentifier) {
        setDomainIdentifier(domainIdentifier);
        return this;
    }

    /**
     * <p>
     * The ID of the asset filter.
     * </p>
     * 
     * @param identifier
     *        The ID of the asset filter.
     */

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    /**
     * <p>
     * The ID of the asset filter.
     * </p>
     * 
     * @return The ID of the asset filter.
     */

    public String getIdentifier() {
        return this.identifier;
    }

    /**
     * <p>
     * The ID of the asset filter.
     * </p>
     * 
     * @param identifier
     *        The ID of the asset filter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetAssetFilterRequest withIdentifier(String identifier) {
        setIdentifier(identifier);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAssetIdentifier() != null)
            sb.append("AssetIdentifier: ").append(getAssetIdentifier()).append(",");
        if (getDomainIdentifier() != null)
            sb.append("DomainIdentifier: ").append(getDomainIdentifier()).append(",");
        if (getIdentifier() != null)
            sb.append("Identifier: ").append(getIdentifier());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetAssetFilterRequest == false)
            return false;
        GetAssetFilterRequest other = (GetAssetFilterRequest) obj;
        if (other.getAssetIdentifier() == null ^ this.getAssetIdentifier() == null)
            return false;
        if (other.getAssetIdentifier() != null && other.getAssetIdentifier().equals(this.getAssetIdentifier()) == false)
            return false;
        if (other.getDomainIdentifier() == null ^ this.getDomainIdentifier() == null)
            return false;
        if (other.getDomainIdentifier() != null && other.getDomainIdentifier().equals(this.getDomainIdentifier()) == false)
            return false;
        if (other.getIdentifier() == null ^ this.getIdentifier() == null)
            return false;
        if (other.getIdentifier() != null && other.getIdentifier().equals(this.getIdentifier()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAssetIdentifier() == null) ? 0 : getAssetIdentifier().hashCode());
        hashCode = prime * hashCode + ((getDomainIdentifier() == null) ? 0 : getDomainIdentifier().hashCode());
        hashCode = prime * hashCode + ((getIdentifier() == null) ? 0 : getIdentifier().hashCode());
        return hashCode;
    }

    @Override
    public GetAssetFilterRequest clone() {
        return (GetAssetFilterRequest) super.clone();
    }

}
