/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datazone.model.FilterExpression;
import com.amazonaws.services.datazone.model.transform.RelationalFilterConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RelationalFilterConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String databaseName;
    private List<FilterExpression> filterExpressions;
    private String schemaName;

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public RelationalFilterConfiguration withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public List<FilterExpression> getFilterExpressions() {
        return this.filterExpressions;
    }

    public void setFilterExpressions(Collection<FilterExpression> filterExpressions) {
        if (filterExpressions == null) {
            this.filterExpressions = null;
            return;
        }
        this.filterExpressions = new ArrayList<FilterExpression>(filterExpressions);
    }

    public RelationalFilterConfiguration withFilterExpressions(FilterExpression ... filterExpressions) {
        if (this.filterExpressions == null) {
            this.setFilterExpressions(new ArrayList<FilterExpression>(filterExpressions.length));
        }
        for (FilterExpression ele : filterExpressions) {
            this.filterExpressions.add(ele);
        }
        return this;
    }

    public RelationalFilterConfiguration withFilterExpressions(Collection<FilterExpression> filterExpressions) {
        this.setFilterExpressions(filterExpressions);
        return this;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public RelationalFilterConfiguration withSchemaName(String schemaName) {
        this.setSchemaName(schemaName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getFilterExpressions() != null) {
            sb.append("FilterExpressions: ").append(this.getFilterExpressions()).append(",");
        }
        if (this.getSchemaName() != null) {
            sb.append("SchemaName: ").append(this.getSchemaName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalFilterConfiguration)) {
            return false;
        }
        RelationalFilterConfiguration other = (RelationalFilterConfiguration)obj;
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getFilterExpressions() == null ^ this.getFilterExpressions() == null) {
            return false;
        }
        if (other.getFilterExpressions() != null && !other.getFilterExpressions().equals(this.getFilterExpressions())) {
            return false;
        }
        if (other.getSchemaName() == null ^ this.getSchemaName() == null) {
            return false;
        }
        return other.getSchemaName() == null || other.getSchemaName().equals(this.getSchemaName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getFilterExpressions() == null ? 0 : this.getFilterExpressions().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaName() == null ? 0 : this.getSchemaName().hashCode());
        return hashCode;
    }

    public RelationalFilterConfiguration clone() {
        try {
            return (RelationalFilterConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RelationalFilterConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

