/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datazone.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The single sign-on details in Amazon DataZone.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SingleSignOn" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SingleSignOn implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The type of single sign-on in Amazon DataZone.
     * </p>
     */
    private String type;
    /**
     * <p>
     * The single sign-on user assignment in Amazon DataZone.
     * </p>
     */
    private String userAssignment;

    /**
     * <p>
     * The type of single sign-on in Amazon DataZone.
     * </p>
     * 
     * @param type
     *        The type of single sign-on in Amazon DataZone.
     * @see AuthType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The type of single sign-on in Amazon DataZone.
     * </p>
     * 
     * @return The type of single sign-on in Amazon DataZone.
     * @see AuthType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The type of single sign-on in Amazon DataZone.
     * </p>
     * 
     * @param type
     *        The type of single sign-on in Amazon DataZone.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AuthType
     */

    public SingleSignOn withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The type of single sign-on in Amazon DataZone.
     * </p>
     * 
     * @param type
     *        The type of single sign-on in Amazon DataZone.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AuthType
     */

    public SingleSignOn withType(AuthType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * The single sign-on user assignment in Amazon DataZone.
     * </p>
     * 
     * @param userAssignment
     *        The single sign-on user assignment in Amazon DataZone.
     * @see UserAssignment
     */

    public void setUserAssignment(String userAssignment) {
        this.userAssignment = userAssignment;
    }

    /**
     * <p>
     * The single sign-on user assignment in Amazon DataZone.
     * </p>
     * 
     * @return The single sign-on user assignment in Amazon DataZone.
     * @see UserAssignment
     */

    public String getUserAssignment() {
        return this.userAssignment;
    }

    /**
     * <p>
     * The single sign-on user assignment in Amazon DataZone.
     * </p>
     * 
     * @param userAssignment
     *        The single sign-on user assignment in Amazon DataZone.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see UserAssignment
     */

    public SingleSignOn withUserAssignment(String userAssignment) {
        setUserAssignment(userAssignment);
        return this;
    }

    /**
     * <p>
     * The single sign-on user assignment in Amazon DataZone.
     * </p>
     * 
     * @param userAssignment
     *        The single sign-on user assignment in Amazon DataZone.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see UserAssignment
     */

    public SingleSignOn withUserAssignment(UserAssignment userAssignment) {
        this.userAssignment = userAssignment.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getUserAssignment() != null)
            sb.append("UserAssignment: ").append(getUserAssignment());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SingleSignOn == false)
            return false;
        SingleSignOn other = (SingleSignOn) obj;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getUserAssignment() == null ^ this.getUserAssignment() == null)
            return false;
        if (other.getUserAssignment() != null && other.getUserAssignment().equals(this.getUserAssignment()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getUserAssignment() == null) ? 0 : getUserAssignment().hashCode());
        return hashCode;
    }

    @Override
    public SingleSignOn clone() {
        try {
            return (SingleSignOn) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.datazone.model.transform.SingleSignOnMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
