/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datasync.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * DescribeTaskRequest
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTask" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeTaskRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the transfer task that you want information about.
     * </p>
     */
    private String taskArn;

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the transfer task that you want information about.
     * </p>
     * 
     * @param taskArn
     *        Specifies the Amazon Resource Name (ARN) of the transfer task that you want information about.
     */

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the transfer task that you want information about.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the transfer task that you want information about.
     */

    public String getTaskArn() {
        return this.taskArn;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the transfer task that you want information about.
     * </p>
     * 
     * @param taskArn
     *        Specifies the Amazon Resource Name (ARN) of the transfer task that you want information about.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeTaskRequest withTaskArn(String taskArn) {
        setTaskArn(taskArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTaskArn() != null)
            sb.append("TaskArn: ").append(getTaskArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeTaskRequest == false)
            return false;
        DescribeTaskRequest other = (DescribeTaskRequest) obj;
        if (other.getTaskArn() == null ^ this.getTaskArn() == null)
            return false;
        if (other.getTaskArn() != null && other.getTaskArn().equals(this.getTaskArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTaskArn() == null) ? 0 : getTaskArn().hashCode());
        return hashCode;
    }

    @Override
    public DescribeTaskRequest clone() {
        return (DescribeTaskRequest) super.clone();
    }

}
