/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.TagListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartDiscoveryJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String storageSystemArn;
    private Integer collectionDurationMinutes;
    private String clientToken;
    private List<TagListEntry> tags;

    public void setStorageSystemArn(String storageSystemArn) {
        this.storageSystemArn = storageSystemArn;
    }

    public String getStorageSystemArn() {
        return this.storageSystemArn;
    }

    public StartDiscoveryJobRequest withStorageSystemArn(String storageSystemArn) {
        this.setStorageSystemArn(storageSystemArn);
        return this;
    }

    public void setCollectionDurationMinutes(Integer collectionDurationMinutes) {
        this.collectionDurationMinutes = collectionDurationMinutes;
    }

    public Integer getCollectionDurationMinutes() {
        return this.collectionDurationMinutes;
    }

    public StartDiscoveryJobRequest withCollectionDurationMinutes(Integer collectionDurationMinutes) {
        this.setCollectionDurationMinutes(collectionDurationMinutes);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public StartDiscoveryJobRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public StartDiscoveryJobRequest withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public StartDiscoveryJobRequest withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStorageSystemArn() != null) {
            sb.append("StorageSystemArn: ").append(this.getStorageSystemArn()).append(",");
        }
        if (this.getCollectionDurationMinutes() != null) {
            sb.append("CollectionDurationMinutes: ").append(this.getCollectionDurationMinutes()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDiscoveryJobRequest)) {
            return false;
        }
        StartDiscoveryJobRequest other = (StartDiscoveryJobRequest)obj;
        if (other.getStorageSystemArn() == null ^ this.getStorageSystemArn() == null) {
            return false;
        }
        if (other.getStorageSystemArn() != null && !other.getStorageSystemArn().equals(this.getStorageSystemArn())) {
            return false;
        }
        if (other.getCollectionDurationMinutes() == null ^ this.getCollectionDurationMinutes() == null) {
            return false;
        }
        if (other.getCollectionDurationMinutes() != null && !other.getCollectionDurationMinutes().equals(this.getCollectionDurationMinutes())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStorageSystemArn() == null ? 0 : this.getStorageSystemArn().hashCode());
        hashCode = 31 * hashCode + (this.getCollectionDurationMinutes() == null ? 0 : this.getCollectionDurationMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public StartDiscoveryJobRequest clone() {
        return (StartDiscoveryJobRequest)super.clone();
    }
}

