/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.FilterRule;
import com.amazonaws.services.datasync.model.Options;
import com.amazonaws.services.datasync.model.TagListEntry;
import com.amazonaws.services.datasync.model.TaskSchedule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateTaskRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceLocationArn;
    private String destinationLocationArn;
    private String cloudWatchLogGroupArn;
    private String name;
    private Options options;
    private List<FilterRule> excludes;
    private TaskSchedule schedule;
    private List<TagListEntry> tags;

    public void setSourceLocationArn(String sourceLocationArn) {
        this.sourceLocationArn = sourceLocationArn;
    }

    public String getSourceLocationArn() {
        return this.sourceLocationArn;
    }

    public CreateTaskRequest withSourceLocationArn(String sourceLocationArn) {
        this.setSourceLocationArn(sourceLocationArn);
        return this;
    }

    public void setDestinationLocationArn(String destinationLocationArn) {
        this.destinationLocationArn = destinationLocationArn;
    }

    public String getDestinationLocationArn() {
        return this.destinationLocationArn;
    }

    public CreateTaskRequest withDestinationLocationArn(String destinationLocationArn) {
        this.setDestinationLocationArn(destinationLocationArn);
        return this;
    }

    public void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
        this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
    }

    public String getCloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public CreateTaskRequest withCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
        this.setCloudWatchLogGroupArn(cloudWatchLogGroupArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateTaskRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public CreateTaskRequest withOptions(Options options) {
        this.setOptions(options);
        return this;
    }

    public List<FilterRule> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection<FilterRule> excludes) {
        if (excludes == null) {
            this.excludes = null;
            return;
        }
        this.excludes = new ArrayList<FilterRule>(excludes);
    }

    public CreateTaskRequest withExcludes(FilterRule ... excludes) {
        if (this.excludes == null) {
            this.setExcludes(new ArrayList<FilterRule>(excludes.length));
        }
        for (FilterRule ele : excludes) {
            this.excludes.add(ele);
        }
        return this;
    }

    public CreateTaskRequest withExcludes(Collection<FilterRule> excludes) {
        this.setExcludes(excludes);
        return this;
    }

    public void setSchedule(TaskSchedule schedule) {
        this.schedule = schedule;
    }

    public TaskSchedule getSchedule() {
        return this.schedule;
    }

    public CreateTaskRequest withSchedule(TaskSchedule schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public CreateTaskRequest withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateTaskRequest withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceLocationArn() != null) {
            sb.append("SourceLocationArn: ").append(this.getSourceLocationArn()).append(",");
        }
        if (this.getDestinationLocationArn() != null) {
            sb.append("DestinationLocationArn: ").append(this.getDestinationLocationArn()).append(",");
        }
        if (this.getCloudWatchLogGroupArn() != null) {
            sb.append("CloudWatchLogGroupArn: ").append(this.getCloudWatchLogGroupArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions()).append(",");
        }
        if (this.getExcludes() != null) {
            sb.append("Excludes: ").append(this.getExcludes()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTaskRequest)) {
            return false;
        }
        CreateTaskRequest other = (CreateTaskRequest)obj;
        if (other.getSourceLocationArn() == null ^ this.getSourceLocationArn() == null) {
            return false;
        }
        if (other.getSourceLocationArn() != null && !other.getSourceLocationArn().equals(this.getSourceLocationArn())) {
            return false;
        }
        if (other.getDestinationLocationArn() == null ^ this.getDestinationLocationArn() == null) {
            return false;
        }
        if (other.getDestinationLocationArn() != null && !other.getDestinationLocationArn().equals(this.getDestinationLocationArn())) {
            return false;
        }
        if (other.getCloudWatchLogGroupArn() == null ^ this.getCloudWatchLogGroupArn() == null) {
            return false;
        }
        if (other.getCloudWatchLogGroupArn() != null && !other.getCloudWatchLogGroupArn().equals(this.getCloudWatchLogGroupArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        if (other.getOptions() != null && !other.getOptions().equals(this.getOptions())) {
            return false;
        }
        if (other.getExcludes() == null ^ this.getExcludes() == null) {
            return false;
        }
        if (other.getExcludes() != null && !other.getExcludes().equals(this.getExcludes())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceLocationArn() == null ? 0 : this.getSourceLocationArn().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationLocationArn() == null ? 0 : this.getDestinationLocationArn().hashCode());
        hashCode = 31 * hashCode + (this.getCloudWatchLogGroupArn() == null ? 0 : this.getCloudWatchLogGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        hashCode = 31 * hashCode + (this.getExcludes() == null ? 0 : this.getExcludes().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateTaskRequest clone() {
        return (CreateTaskRequest)super.clone();
    }
}

