/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.ObjectStorageServerProtocol;
import com.amazonaws.services.datasync.model.TagListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateLocationObjectStorageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String serverHostname;
    private Integer serverPort;
    private String serverProtocol;
    private String subdirectory;
    private String bucketName;
    private String accessKey;
    private String secretKey;
    private List<String> agentArns;
    private List<TagListEntry> tags;

    public void setServerHostname(String serverHostname) {
        this.serverHostname = serverHostname;
    }

    public String getServerHostname() {
        return this.serverHostname;
    }

    public CreateLocationObjectStorageRequest withServerHostname(String serverHostname) {
        this.setServerHostname(serverHostname);
        return this;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public CreateLocationObjectStorageRequest withServerPort(Integer serverPort) {
        this.setServerPort(serverPort);
        return this;
    }

    public void setServerProtocol(String serverProtocol) {
        this.serverProtocol = serverProtocol;
    }

    public String getServerProtocol() {
        return this.serverProtocol;
    }

    public CreateLocationObjectStorageRequest withServerProtocol(String serverProtocol) {
        this.setServerProtocol(serverProtocol);
        return this;
    }

    public CreateLocationObjectStorageRequest withServerProtocol(ObjectStorageServerProtocol serverProtocol) {
        this.serverProtocol = serverProtocol.toString();
        return this;
    }

    public void setSubdirectory(String subdirectory) {
        this.subdirectory = subdirectory;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public CreateLocationObjectStorageRequest withSubdirectory(String subdirectory) {
        this.setSubdirectory(subdirectory);
        return this;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public CreateLocationObjectStorageRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public CreateLocationObjectStorageRequest withAccessKey(String accessKey) {
        this.setAccessKey(accessKey);
        return this;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public CreateLocationObjectStorageRequest withSecretKey(String secretKey) {
        this.setSecretKey(secretKey);
        return this;
    }

    public List<String> getAgentArns() {
        return this.agentArns;
    }

    public void setAgentArns(Collection<String> agentArns) {
        if (agentArns == null) {
            this.agentArns = null;
            return;
        }
        this.agentArns = new ArrayList<String>(agentArns);
    }

    public CreateLocationObjectStorageRequest withAgentArns(String ... agentArns) {
        if (this.agentArns == null) {
            this.setAgentArns(new ArrayList<String>(agentArns.length));
        }
        for (String ele : agentArns) {
            this.agentArns.add(ele);
        }
        return this;
    }

    public CreateLocationObjectStorageRequest withAgentArns(Collection<String> agentArns) {
        this.setAgentArns(agentArns);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public CreateLocationObjectStorageRequest withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateLocationObjectStorageRequest withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServerHostname() != null) {
            sb.append("ServerHostname: ").append(this.getServerHostname()).append(",");
        }
        if (this.getServerPort() != null) {
            sb.append("ServerPort: ").append(this.getServerPort()).append(",");
        }
        if (this.getServerProtocol() != null) {
            sb.append("ServerProtocol: ").append(this.getServerProtocol()).append(",");
        }
        if (this.getSubdirectory() != null) {
            sb.append("Subdirectory: ").append(this.getSubdirectory()).append(",");
        }
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getAccessKey() != null) {
            sb.append("AccessKey: ").append(this.getAccessKey()).append(",");
        }
        if (this.getSecretKey() != null) {
            sb.append("SecretKey: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAgentArns() != null) {
            sb.append("AgentArns: ").append(this.getAgentArns()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationObjectStorageRequest)) {
            return false;
        }
        CreateLocationObjectStorageRequest other = (CreateLocationObjectStorageRequest)obj;
        if (other.getServerHostname() == null ^ this.getServerHostname() == null) {
            return false;
        }
        if (other.getServerHostname() != null && !other.getServerHostname().equals(this.getServerHostname())) {
            return false;
        }
        if (other.getServerPort() == null ^ this.getServerPort() == null) {
            return false;
        }
        if (other.getServerPort() != null && !other.getServerPort().equals(this.getServerPort())) {
            return false;
        }
        if (other.getServerProtocol() == null ^ this.getServerProtocol() == null) {
            return false;
        }
        if (other.getServerProtocol() != null && !other.getServerProtocol().equals(this.getServerProtocol())) {
            return false;
        }
        if (other.getSubdirectory() == null ^ this.getSubdirectory() == null) {
            return false;
        }
        if (other.getSubdirectory() != null && !other.getSubdirectory().equals(this.getSubdirectory())) {
            return false;
        }
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getAccessKey() == null ^ this.getAccessKey() == null) {
            return false;
        }
        if (other.getAccessKey() != null && !other.getAccessKey().equals(this.getAccessKey())) {
            return false;
        }
        if (other.getSecretKey() == null ^ this.getSecretKey() == null) {
            return false;
        }
        if (other.getSecretKey() != null && !other.getSecretKey().equals(this.getSecretKey())) {
            return false;
        }
        if (other.getAgentArns() == null ^ this.getAgentArns() == null) {
            return false;
        }
        if (other.getAgentArns() != null && !other.getAgentArns().equals(this.getAgentArns())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServerHostname() == null ? 0 : this.getServerHostname().hashCode());
        hashCode = 31 * hashCode + (this.getServerPort() == null ? 0 : this.getServerPort().hashCode());
        hashCode = 31 * hashCode + (this.getServerProtocol() == null ? 0 : this.getServerProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getSubdirectory() == null ? 0 : this.getSubdirectory().hashCode());
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getAccessKey() == null ? 0 : this.getAccessKey().hashCode());
        hashCode = 31 * hashCode + (this.getSecretKey() == null ? 0 : this.getSecretKey().hashCode());
        hashCode = 31 * hashCode + (this.getAgentArns() == null ? 0 : this.getAgentArns().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateLocationObjectStorageRequest clone() {
        return (CreateLocationObjectStorageRequest)super.clone();
    }
}

