/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.FilterRule;
import com.amazonaws.services.datasync.model.Options;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartTaskExecutionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String taskArn;
    private Options overrideOptions;
    private List<FilterRule> includes;

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public StartTaskExecutionRequest withTaskArn(String taskArn) {
        this.setTaskArn(taskArn);
        return this;
    }

    public void setOverrideOptions(Options overrideOptions) {
        this.overrideOptions = overrideOptions;
    }

    public Options getOverrideOptions() {
        return this.overrideOptions;
    }

    public StartTaskExecutionRequest withOverrideOptions(Options overrideOptions) {
        this.setOverrideOptions(overrideOptions);
        return this;
    }

    public List<FilterRule> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection<FilterRule> includes) {
        if (includes == null) {
            this.includes = null;
            return;
        }
        this.includes = new ArrayList<FilterRule>(includes);
    }

    public StartTaskExecutionRequest withIncludes(FilterRule ... includes) {
        if (this.includes == null) {
            this.setIncludes(new ArrayList<FilterRule>(includes.length));
        }
        for (FilterRule ele : includes) {
            this.includes.add(ele);
        }
        return this;
    }

    public StartTaskExecutionRequest withIncludes(Collection<FilterRule> includes) {
        this.setIncludes(includes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: ").append(this.getTaskArn()).append(",");
        }
        if (this.getOverrideOptions() != null) {
            sb.append("OverrideOptions: ").append(this.getOverrideOptions()).append(",");
        }
        if (this.getIncludes() != null) {
            sb.append("Includes: ").append(this.getIncludes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskExecutionRequest)) {
            return false;
        }
        StartTaskExecutionRequest other = (StartTaskExecutionRequest)obj;
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getOverrideOptions() == null ^ this.getOverrideOptions() == null) {
            return false;
        }
        if (other.getOverrideOptions() != null && !other.getOverrideOptions().equals(this.getOverrideOptions())) {
            return false;
        }
        if (other.getIncludes() == null ^ this.getIncludes() == null) {
            return false;
        }
        return other.getIncludes() == null || other.getIncludes().equals(this.getIncludes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getOverrideOptions() == null ? 0 : this.getOverrideOptions().hashCode());
        hashCode = 31 * hashCode + (this.getIncludes() == null ? 0 : this.getIncludes().hashCode());
        return hashCode;
    }

    public StartTaskExecutionRequest clone() {
        return (StartTaskExecutionRequest)super.clone();
    }
}

