/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import java.util.List;

@SdkInternalApi
public class PipelineObjectMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<List> FIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fields").build();
    private static final PipelineObjectMarshaller instance = new PipelineObjectMarshaller();

    public static PipelineObjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(PipelineObject pipelineObject, ProtocolMarshaller protocolMarshaller) {
        if (pipelineObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)pipelineObject.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)pipelineObject.getName(), NAME_BINDING);
            protocolMarshaller.marshall(pipelineObject.getFields(), FIELDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

