/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.S3DataAccessAsset;
import java.util.List;

@SdkInternalApi
public class S3DataAccessAssetMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bucket").build();
    private static final MarshallingInfo<List> KEYPREFIXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyPrefixes").build();
    private static final MarshallingInfo<List> KEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keys").build();
    private static final MarshallingInfo<String> S3ACCESSPOINTALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3AccessPointAlias").build();
    private static final MarshallingInfo<String> S3ACCESSPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3AccessPointArn").build();
    private static final S3DataAccessAssetMarshaller instance = new S3DataAccessAssetMarshaller();

    public static S3DataAccessAssetMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3DataAccessAsset s3DataAccessAsset, ProtocolMarshaller protocolMarshaller) {
        if (s3DataAccessAsset == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3DataAccessAsset.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall(s3DataAccessAsset.getKeyPrefixes(), KEYPREFIXES_BINDING);
            protocolMarshaller.marshall(s3DataAccessAsset.getKeys(), KEYS_BINDING);
            protocolMarshaller.marshall((Object)s3DataAccessAsset.getS3AccessPointAlias(), S3ACCESSPOINTALIAS_BINDING);
            protocolMarshaller.marshall((Object)s3DataAccessAsset.getS3AccessPointArn(), S3ACCESSPOINTARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

