/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.customerprofiles.model.transform.MatchItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MatchItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String matchId;
    private List<String> profileIds;
    private Double confidenceScore;

    public void setMatchId(String matchId) {
        this.matchId = matchId;
    }

    public String getMatchId() {
        return this.matchId;
    }

    public MatchItem withMatchId(String matchId) {
        this.setMatchId(matchId);
        return this;
    }

    public List<String> getProfileIds() {
        return this.profileIds;
    }

    public void setProfileIds(Collection<String> profileIds) {
        if (profileIds == null) {
            this.profileIds = null;
            return;
        }
        this.profileIds = new ArrayList<String>(profileIds);
    }

    public MatchItem withProfileIds(String ... profileIds) {
        if (this.profileIds == null) {
            this.setProfileIds(new ArrayList<String>(profileIds.length));
        }
        for (String ele : profileIds) {
            this.profileIds.add(ele);
        }
        return this;
    }

    public MatchItem withProfileIds(Collection<String> profileIds) {
        this.setProfileIds(profileIds);
        return this;
    }

    public void setConfidenceScore(Double confidenceScore) {
        this.confidenceScore = confidenceScore;
    }

    public Double getConfidenceScore() {
        return this.confidenceScore;
    }

    public MatchItem withConfidenceScore(Double confidenceScore) {
        this.setConfidenceScore(confidenceScore);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMatchId() != null) {
            sb.append("MatchId: ").append(this.getMatchId()).append(",");
        }
        if (this.getProfileIds() != null) {
            sb.append("ProfileIds: ").append(this.getProfileIds()).append(",");
        }
        if (this.getConfidenceScore() != null) {
            sb.append("ConfidenceScore: ").append(this.getConfidenceScore());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchItem)) {
            return false;
        }
        MatchItem other = (MatchItem)obj;
        if (other.getMatchId() == null ^ this.getMatchId() == null) {
            return false;
        }
        if (other.getMatchId() != null && !other.getMatchId().equals(this.getMatchId())) {
            return false;
        }
        if (other.getProfileIds() == null ^ this.getProfileIds() == null) {
            return false;
        }
        if (other.getProfileIds() != null && !other.getProfileIds().equals(this.getProfileIds())) {
            return false;
        }
        if (other.getConfidenceScore() == null ^ this.getConfidenceScore() == null) {
            return false;
        }
        return other.getConfidenceScore() == null || other.getConfidenceScore().equals(this.getConfidenceScore());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMatchId() == null ? 0 : this.getMatchId().hashCode());
        hashCode = 31 * hashCode + (this.getProfileIds() == null ? 0 : this.getProfileIds().hashCode());
        hashCode = 31 * hashCode + (this.getConfidenceScore() == null ? 0 : this.getConfidenceScore().hashCode());
        return hashCode;
    }

    public MatchItem clone() {
        try {
            return (MatchItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MatchItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

