/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.customerprofiles.model.AttributeTypesSelector;
import com.amazonaws.services.customerprofiles.model.ConflictResolution;
import com.amazonaws.services.customerprofiles.model.ExportingConfig;
import com.amazonaws.services.customerprofiles.model.MatchingRule;
import com.amazonaws.services.customerprofiles.model.RuleBasedMatchingStatus;
import com.amazonaws.services.customerprofiles.model.transform.RuleBasedMatchingResponseMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RuleBasedMatchingResponse
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean enabled;
    private List<MatchingRule> matchingRules;
    private String status;
    private Integer maxAllowedRuleLevelForMerging;
    private Integer maxAllowedRuleLevelForMatching;
    private AttributeTypesSelector attributeTypesSelector;
    private ConflictResolution conflictResolution;
    private ExportingConfig exportingConfig;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public RuleBasedMatchingResponse withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public List<MatchingRule> getMatchingRules() {
        return this.matchingRules;
    }

    public void setMatchingRules(Collection<MatchingRule> matchingRules) {
        if (matchingRules == null) {
            this.matchingRules = null;
            return;
        }
        this.matchingRules = new ArrayList<MatchingRule>(matchingRules);
    }

    public RuleBasedMatchingResponse withMatchingRules(MatchingRule ... matchingRules) {
        if (this.matchingRules == null) {
            this.setMatchingRules(new ArrayList<MatchingRule>(matchingRules.length));
        }
        for (MatchingRule ele : matchingRules) {
            this.matchingRules.add(ele);
        }
        return this;
    }

    public RuleBasedMatchingResponse withMatchingRules(Collection<MatchingRule> matchingRules) {
        this.setMatchingRules(matchingRules);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public RuleBasedMatchingResponse withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public RuleBasedMatchingResponse withStatus(RuleBasedMatchingStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setMaxAllowedRuleLevelForMerging(Integer maxAllowedRuleLevelForMerging) {
        this.maxAllowedRuleLevelForMerging = maxAllowedRuleLevelForMerging;
    }

    public Integer getMaxAllowedRuleLevelForMerging() {
        return this.maxAllowedRuleLevelForMerging;
    }

    public RuleBasedMatchingResponse withMaxAllowedRuleLevelForMerging(Integer maxAllowedRuleLevelForMerging) {
        this.setMaxAllowedRuleLevelForMerging(maxAllowedRuleLevelForMerging);
        return this;
    }

    public void setMaxAllowedRuleLevelForMatching(Integer maxAllowedRuleLevelForMatching) {
        this.maxAllowedRuleLevelForMatching = maxAllowedRuleLevelForMatching;
    }

    public Integer getMaxAllowedRuleLevelForMatching() {
        return this.maxAllowedRuleLevelForMatching;
    }

    public RuleBasedMatchingResponse withMaxAllowedRuleLevelForMatching(Integer maxAllowedRuleLevelForMatching) {
        this.setMaxAllowedRuleLevelForMatching(maxAllowedRuleLevelForMatching);
        return this;
    }

    public void setAttributeTypesSelector(AttributeTypesSelector attributeTypesSelector) {
        this.attributeTypesSelector = attributeTypesSelector;
    }

    public AttributeTypesSelector getAttributeTypesSelector() {
        return this.attributeTypesSelector;
    }

    public RuleBasedMatchingResponse withAttributeTypesSelector(AttributeTypesSelector attributeTypesSelector) {
        this.setAttributeTypesSelector(attributeTypesSelector);
        return this;
    }

    public void setConflictResolution(ConflictResolution conflictResolution) {
        this.conflictResolution = conflictResolution;
    }

    public ConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    public RuleBasedMatchingResponse withConflictResolution(ConflictResolution conflictResolution) {
        this.setConflictResolution(conflictResolution);
        return this;
    }

    public void setExportingConfig(ExportingConfig exportingConfig) {
        this.exportingConfig = exportingConfig;
    }

    public ExportingConfig getExportingConfig() {
        return this.exportingConfig;
    }

    public RuleBasedMatchingResponse withExportingConfig(ExportingConfig exportingConfig) {
        this.setExportingConfig(exportingConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getMatchingRules() != null) {
            sb.append("MatchingRules: ").append(this.getMatchingRules()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getMaxAllowedRuleLevelForMerging() != null) {
            sb.append("MaxAllowedRuleLevelForMerging: ").append(this.getMaxAllowedRuleLevelForMerging()).append(",");
        }
        if (this.getMaxAllowedRuleLevelForMatching() != null) {
            sb.append("MaxAllowedRuleLevelForMatching: ").append(this.getMaxAllowedRuleLevelForMatching()).append(",");
        }
        if (this.getAttributeTypesSelector() != null) {
            sb.append("AttributeTypesSelector: ").append(this.getAttributeTypesSelector()).append(",");
        }
        if (this.getConflictResolution() != null) {
            sb.append("ConflictResolution: ").append(this.getConflictResolution()).append(",");
        }
        if (this.getExportingConfig() != null) {
            sb.append("ExportingConfig: ").append(this.getExportingConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleBasedMatchingResponse)) {
            return false;
        }
        RuleBasedMatchingResponse other = (RuleBasedMatchingResponse)obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getMatchingRules() == null ^ this.getMatchingRules() == null) {
            return false;
        }
        if (other.getMatchingRules() != null && !other.getMatchingRules().equals(this.getMatchingRules())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getMaxAllowedRuleLevelForMerging() == null ^ this.getMaxAllowedRuleLevelForMerging() == null) {
            return false;
        }
        if (other.getMaxAllowedRuleLevelForMerging() != null && !other.getMaxAllowedRuleLevelForMerging().equals(this.getMaxAllowedRuleLevelForMerging())) {
            return false;
        }
        if (other.getMaxAllowedRuleLevelForMatching() == null ^ this.getMaxAllowedRuleLevelForMatching() == null) {
            return false;
        }
        if (other.getMaxAllowedRuleLevelForMatching() != null && !other.getMaxAllowedRuleLevelForMatching().equals(this.getMaxAllowedRuleLevelForMatching())) {
            return false;
        }
        if (other.getAttributeTypesSelector() == null ^ this.getAttributeTypesSelector() == null) {
            return false;
        }
        if (other.getAttributeTypesSelector() != null && !other.getAttributeTypesSelector().equals(this.getAttributeTypesSelector())) {
            return false;
        }
        if (other.getConflictResolution() == null ^ this.getConflictResolution() == null) {
            return false;
        }
        if (other.getConflictResolution() != null && !other.getConflictResolution().equals(this.getConflictResolution())) {
            return false;
        }
        if (other.getExportingConfig() == null ^ this.getExportingConfig() == null) {
            return false;
        }
        return other.getExportingConfig() == null || other.getExportingConfig().equals(this.getExportingConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getMatchingRules() == null ? 0 : this.getMatchingRules().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMaxAllowedRuleLevelForMerging() == null ? 0 : this.getMaxAllowedRuleLevelForMerging().hashCode());
        hashCode = 31 * hashCode + (this.getMaxAllowedRuleLevelForMatching() == null ? 0 : this.getMaxAllowedRuleLevelForMatching().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeTypesSelector() == null ? 0 : this.getAttributeTypesSelector().hashCode());
        hashCode = 31 * hashCode + (this.getConflictResolution() == null ? 0 : this.getConflictResolution().hashCode());
        hashCode = 31 * hashCode + (this.getExportingConfig() == null ? 0 : this.getExportingConfig().hashCode());
        return hashCode;
    }

    public RuleBasedMatchingResponse clone() {
        try {
            return (RuleBasedMatchingResponse)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleBasedMatchingResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

