/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costoptimizationhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costoptimizationhub.model.ActionType;
import com.amazonaws.services.costoptimizationhub.model.ImplementationEffort;
import com.amazonaws.services.costoptimizationhub.model.ResourceType;
import com.amazonaws.services.costoptimizationhub.model.Tag;
import com.amazonaws.services.costoptimizationhub.model.transform.FilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Filter
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean restartNeeded;
    private Boolean rollbackPossible;
    private List<String> implementationEfforts;
    private List<String> accountIds;
    private List<String> regions;
    private List<String> resourceTypes;
    private List<String> actionTypes;
    private List<Tag> tags;
    private List<String> resourceIds;
    private List<String> resourceArns;
    private List<String> recommendationIds;

    public void setRestartNeeded(Boolean restartNeeded) {
        this.restartNeeded = restartNeeded;
    }

    public Boolean getRestartNeeded() {
        return this.restartNeeded;
    }

    public Filter withRestartNeeded(Boolean restartNeeded) {
        this.setRestartNeeded(restartNeeded);
        return this;
    }

    public Boolean isRestartNeeded() {
        return this.restartNeeded;
    }

    public void setRollbackPossible(Boolean rollbackPossible) {
        this.rollbackPossible = rollbackPossible;
    }

    public Boolean getRollbackPossible() {
        return this.rollbackPossible;
    }

    public Filter withRollbackPossible(Boolean rollbackPossible) {
        this.setRollbackPossible(rollbackPossible);
        return this;
    }

    public Boolean isRollbackPossible() {
        return this.rollbackPossible;
    }

    public List<String> getImplementationEfforts() {
        return this.implementationEfforts;
    }

    public void setImplementationEfforts(Collection<String> implementationEfforts) {
        if (implementationEfforts == null) {
            this.implementationEfforts = null;
            return;
        }
        this.implementationEfforts = new ArrayList<String>(implementationEfforts);
    }

    public Filter withImplementationEfforts(String ... implementationEfforts) {
        if (this.implementationEfforts == null) {
            this.setImplementationEfforts(new ArrayList<String>(implementationEfforts.length));
        }
        for (String ele : implementationEfforts) {
            this.implementationEfforts.add(ele);
        }
        return this;
    }

    public Filter withImplementationEfforts(Collection<String> implementationEfforts) {
        this.setImplementationEfforts(implementationEfforts);
        return this;
    }

    public Filter withImplementationEfforts(ImplementationEffort ... implementationEfforts) {
        ArrayList<String> implementationEffortsCopy = new ArrayList<String>(implementationEfforts.length);
        for (ImplementationEffort value : implementationEfforts) {
            implementationEffortsCopy.add(value.toString());
        }
        if (this.getImplementationEfforts() == null) {
            this.setImplementationEfforts(implementationEffortsCopy);
        } else {
            this.getImplementationEfforts().addAll(implementationEffortsCopy);
        }
        return this;
    }

    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Collection<String> accountIds) {
        if (accountIds == null) {
            this.accountIds = null;
            return;
        }
        this.accountIds = new ArrayList<String>(accountIds);
    }

    public Filter withAccountIds(String ... accountIds) {
        if (this.accountIds == null) {
            this.setAccountIds(new ArrayList<String>(accountIds.length));
        }
        for (String ele : accountIds) {
            this.accountIds.add(ele);
        }
        return this;
    }

    public Filter withAccountIds(Collection<String> accountIds) {
        this.setAccountIds(accountIds);
        return this;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public void setRegions(Collection<String> regions) {
        if (regions == null) {
            this.regions = null;
            return;
        }
        this.regions = new ArrayList<String>(regions);
    }

    public Filter withRegions(String ... regions) {
        if (this.regions == null) {
            this.setRegions(new ArrayList<String>(regions.length));
        }
        for (String ele : regions) {
            this.regions.add(ele);
        }
        return this;
    }

    public Filter withRegions(Collection<String> regions) {
        this.setRegions(regions);
        return this;
    }

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new ArrayList<String>(resourceTypes);
    }

    public Filter withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes(new ArrayList<String>(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add(ele);
        }
        return this;
    }

    public Filter withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public Filter withResourceTypes(ResourceType ... resourceTypes) {
        ArrayList<String> resourceTypesCopy = new ArrayList<String>(resourceTypes.length);
        for (ResourceType value : resourceTypes) {
            resourceTypesCopy.add(value.toString());
        }
        if (this.getResourceTypes() == null) {
            this.setResourceTypes(resourceTypesCopy);
        } else {
            this.getResourceTypes().addAll(resourceTypesCopy);
        }
        return this;
    }

    public List<String> getActionTypes() {
        return this.actionTypes;
    }

    public void setActionTypes(Collection<String> actionTypes) {
        if (actionTypes == null) {
            this.actionTypes = null;
            return;
        }
        this.actionTypes = new ArrayList<String>(actionTypes);
    }

    public Filter withActionTypes(String ... actionTypes) {
        if (this.actionTypes == null) {
            this.setActionTypes(new ArrayList<String>(actionTypes.length));
        }
        for (String ele : actionTypes) {
            this.actionTypes.add(ele);
        }
        return this;
    }

    public Filter withActionTypes(Collection<String> actionTypes) {
        this.setActionTypes(actionTypes);
        return this;
    }

    public Filter withActionTypes(ActionType ... actionTypes) {
        ArrayList<String> actionTypesCopy = new ArrayList<String>(actionTypes.length);
        for (ActionType value : actionTypes) {
            actionTypesCopy.add(value.toString());
        }
        if (this.getActionTypes() == null) {
            this.setActionTypes(actionTypesCopy);
        } else {
            this.getActionTypes().addAll(actionTypesCopy);
        }
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Filter withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Filter withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        this.resourceIds = new ArrayList<String>(resourceIds);
    }

    public Filter withResourceIds(String ... resourceIds) {
        if (this.resourceIds == null) {
            this.setResourceIds(new ArrayList<String>(resourceIds.length));
        }
        for (String ele : resourceIds) {
            this.resourceIds.add(ele);
        }
        return this;
    }

    public Filter withResourceIds(Collection<String> resourceIds) {
        this.setResourceIds(resourceIds);
        return this;
    }

    public List<String> getResourceArns() {
        return this.resourceArns;
    }

    public void setResourceArns(Collection<String> resourceArns) {
        if (resourceArns == null) {
            this.resourceArns = null;
            return;
        }
        this.resourceArns = new ArrayList<String>(resourceArns);
    }

    public Filter withResourceArns(String ... resourceArns) {
        if (this.resourceArns == null) {
            this.setResourceArns(new ArrayList<String>(resourceArns.length));
        }
        for (String ele : resourceArns) {
            this.resourceArns.add(ele);
        }
        return this;
    }

    public Filter withResourceArns(Collection<String> resourceArns) {
        this.setResourceArns(resourceArns);
        return this;
    }

    public List<String> getRecommendationIds() {
        return this.recommendationIds;
    }

    public void setRecommendationIds(Collection<String> recommendationIds) {
        if (recommendationIds == null) {
            this.recommendationIds = null;
            return;
        }
        this.recommendationIds = new ArrayList<String>(recommendationIds);
    }

    public Filter withRecommendationIds(String ... recommendationIds) {
        if (this.recommendationIds == null) {
            this.setRecommendationIds(new ArrayList<String>(recommendationIds.length));
        }
        for (String ele : recommendationIds) {
            this.recommendationIds.add(ele);
        }
        return this;
    }

    public Filter withRecommendationIds(Collection<String> recommendationIds) {
        this.setRecommendationIds(recommendationIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRestartNeeded() != null) {
            sb.append("RestartNeeded: ").append(this.getRestartNeeded()).append(",");
        }
        if (this.getRollbackPossible() != null) {
            sb.append("RollbackPossible: ").append(this.getRollbackPossible()).append(",");
        }
        if (this.getImplementationEfforts() != null) {
            sb.append("ImplementationEfforts: ").append(this.getImplementationEfforts()).append(",");
        }
        if (this.getAccountIds() != null) {
            sb.append("AccountIds: ").append(this.getAccountIds()).append(",");
        }
        if (this.getRegions() != null) {
            sb.append("Regions: ").append(this.getRegions()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes()).append(",");
        }
        if (this.getActionTypes() != null) {
            sb.append("ActionTypes: ").append(this.getActionTypes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: ").append(this.getResourceIds()).append(",");
        }
        if (this.getResourceArns() != null) {
            sb.append("ResourceArns: ").append(this.getResourceArns()).append(",");
        }
        if (this.getRecommendationIds() != null) {
            sb.append("RecommendationIds: ").append(this.getRecommendationIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        if (other.getRestartNeeded() == null ^ this.getRestartNeeded() == null) {
            return false;
        }
        if (other.getRestartNeeded() != null && !other.getRestartNeeded().equals(this.getRestartNeeded())) {
            return false;
        }
        if (other.getRollbackPossible() == null ^ this.getRollbackPossible() == null) {
            return false;
        }
        if (other.getRollbackPossible() != null && !other.getRollbackPossible().equals(this.getRollbackPossible())) {
            return false;
        }
        if (other.getImplementationEfforts() == null ^ this.getImplementationEfforts() == null) {
            return false;
        }
        if (other.getImplementationEfforts() != null && !other.getImplementationEfforts().equals(this.getImplementationEfforts())) {
            return false;
        }
        if (other.getAccountIds() == null ^ this.getAccountIds() == null) {
            return false;
        }
        if (other.getAccountIds() != null && !other.getAccountIds().equals(this.getAccountIds())) {
            return false;
        }
        if (other.getRegions() == null ^ this.getRegions() == null) {
            return false;
        }
        if (other.getRegions() != null && !other.getRegions().equals(this.getRegions())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        if (other.getResourceTypes() != null && !other.getResourceTypes().equals(this.getResourceTypes())) {
            return false;
        }
        if (other.getActionTypes() == null ^ this.getActionTypes() == null) {
            return false;
        }
        if (other.getActionTypes() != null && !other.getActionTypes().equals(this.getActionTypes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        if (other.getResourceIds() != null && !other.getResourceIds().equals(this.getResourceIds())) {
            return false;
        }
        if (other.getResourceArns() == null ^ this.getResourceArns() == null) {
            return false;
        }
        if (other.getResourceArns() != null && !other.getResourceArns().equals(this.getResourceArns())) {
            return false;
        }
        if (other.getRecommendationIds() == null ^ this.getRecommendationIds() == null) {
            return false;
        }
        return other.getRecommendationIds() == null || other.getRecommendationIds().equals(this.getRecommendationIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRestartNeeded() == null ? 0 : this.getRestartNeeded().hashCode());
        hashCode = 31 * hashCode + (this.getRollbackPossible() == null ? 0 : this.getRollbackPossible().hashCode());
        hashCode = 31 * hashCode + (this.getImplementationEfforts() == null ? 0 : this.getImplementationEfforts().hashCode());
        hashCode = 31 * hashCode + (this.getAccountIds() == null ? 0 : this.getAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getRegions() == null ? 0 : this.getRegions().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getActionTypes() == null ? 0 : this.getActionTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArns() == null ? 0 : this.getResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationIds() == null ? 0 : this.getRecommendationIds().hashCode());
        return hashCode;
    }

    public Filter clone() {
        try {
            return (Filter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

