/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.costexplorer.model.CostCategoryRule;
import com.amazonaws.services.costexplorer.model.CostCategoryRuleVersion;
import com.amazonaws.services.costexplorer.model.CostCategorySplitChargeRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCostCategoryDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String ruleVersion;
    private List<CostCategoryRule> rules;
    private String defaultValue;
    private List<CostCategorySplitChargeRule> splitChargeRules;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateCostCategoryDefinitionRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRuleVersion(String ruleVersion) {
        this.ruleVersion = ruleVersion;
    }

    public String getRuleVersion() {
        return this.ruleVersion;
    }

    public CreateCostCategoryDefinitionRequest withRuleVersion(String ruleVersion) {
        this.setRuleVersion(ruleVersion);
        return this;
    }

    public CreateCostCategoryDefinitionRequest withRuleVersion(CostCategoryRuleVersion ruleVersion) {
        this.ruleVersion = ruleVersion.toString();
        return this;
    }

    public List<CostCategoryRule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<CostCategoryRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<CostCategoryRule>(rules);
    }

    public CreateCostCategoryDefinitionRequest withRules(CostCategoryRule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<CostCategoryRule>(rules.length));
        }
        for (CostCategoryRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public CreateCostCategoryDefinitionRequest withRules(Collection<CostCategoryRule> rules) {
        this.setRules(rules);
        return this;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public CreateCostCategoryDefinitionRequest withDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public List<CostCategorySplitChargeRule> getSplitChargeRules() {
        return this.splitChargeRules;
    }

    public void setSplitChargeRules(Collection<CostCategorySplitChargeRule> splitChargeRules) {
        if (splitChargeRules == null) {
            this.splitChargeRules = null;
            return;
        }
        this.splitChargeRules = new ArrayList<CostCategorySplitChargeRule>(splitChargeRules);
    }

    public CreateCostCategoryDefinitionRequest withSplitChargeRules(CostCategorySplitChargeRule ... splitChargeRules) {
        if (this.splitChargeRules == null) {
            this.setSplitChargeRules(new ArrayList<CostCategorySplitChargeRule>(splitChargeRules.length));
        }
        for (CostCategorySplitChargeRule ele : splitChargeRules) {
            this.splitChargeRules.add(ele);
        }
        return this;
    }

    public CreateCostCategoryDefinitionRequest withSplitChargeRules(Collection<CostCategorySplitChargeRule> splitChargeRules) {
        this.setSplitChargeRules(splitChargeRules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRuleVersion() != null) {
            sb.append("RuleVersion: ").append(this.getRuleVersion()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue()).append(",");
        }
        if (this.getSplitChargeRules() != null) {
            sb.append("SplitChargeRules: ").append(this.getSplitChargeRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCostCategoryDefinitionRequest)) {
            return false;
        }
        CreateCostCategoryDefinitionRequest other = (CreateCostCategoryDefinitionRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRuleVersion() == null ^ this.getRuleVersion() == null) {
            return false;
        }
        if (other.getRuleVersion() != null && !other.getRuleVersion().equals(this.getRuleVersion())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getSplitChargeRules() == null ^ this.getSplitChargeRules() == null) {
            return false;
        }
        return other.getSplitChargeRules() == null || other.getSplitChargeRules().equals(this.getSplitChargeRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRuleVersion() == null ? 0 : this.getRuleVersion().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getSplitChargeRules() == null ? 0 : this.getSplitChargeRules().hashCode());
        return hashCode;
    }

    public CreateCostCategoryDefinitionRequest clone() {
        return (CreateCostCategoryDefinitionRequest)super.clone();
    }
}

