/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.costexplorer.model.CostCategoryRule;
import com.amazonaws.services.costexplorer.model.CostCategoryRuleVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateCostCategoryDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String costCategoryArn;
    private String ruleVersion;
    private List<CostCategoryRule> rules;
    private String defaultValue;

    public void setCostCategoryArn(String costCategoryArn) {
        this.costCategoryArn = costCategoryArn;
    }

    public String getCostCategoryArn() {
        return this.costCategoryArn;
    }

    public UpdateCostCategoryDefinitionRequest withCostCategoryArn(String costCategoryArn) {
        this.setCostCategoryArn(costCategoryArn);
        return this;
    }

    public void setRuleVersion(String ruleVersion) {
        this.ruleVersion = ruleVersion;
    }

    public String getRuleVersion() {
        return this.ruleVersion;
    }

    public UpdateCostCategoryDefinitionRequest withRuleVersion(String ruleVersion) {
        this.setRuleVersion(ruleVersion);
        return this;
    }

    public UpdateCostCategoryDefinitionRequest withRuleVersion(CostCategoryRuleVersion ruleVersion) {
        this.ruleVersion = ruleVersion.toString();
        return this;
    }

    public List<CostCategoryRule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<CostCategoryRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<CostCategoryRule>(rules);
    }

    public UpdateCostCategoryDefinitionRequest withRules(CostCategoryRule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<CostCategoryRule>(rules.length));
        }
        for (CostCategoryRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public UpdateCostCategoryDefinitionRequest withRules(Collection<CostCategoryRule> rules) {
        this.setRules(rules);
        return this;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public UpdateCostCategoryDefinitionRequest withDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCostCategoryArn() != null) {
            sb.append("CostCategoryArn: ").append(this.getCostCategoryArn()).append(",");
        }
        if (this.getRuleVersion() != null) {
            sb.append("RuleVersion: ").append(this.getRuleVersion()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCostCategoryDefinitionRequest)) {
            return false;
        }
        UpdateCostCategoryDefinitionRequest other = (UpdateCostCategoryDefinitionRequest)obj;
        if (other.getCostCategoryArn() == null ^ this.getCostCategoryArn() == null) {
            return false;
        }
        if (other.getCostCategoryArn() != null && !other.getCostCategoryArn().equals(this.getCostCategoryArn())) {
            return false;
        }
        if (other.getRuleVersion() == null ^ this.getRuleVersion() == null) {
            return false;
        }
        if (other.getRuleVersion() != null && !other.getRuleVersion().equals(this.getRuleVersion())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        return other.getDefaultValue() == null || other.getDefaultValue().equals(this.getDefaultValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCostCategoryArn() == null ? 0 : this.getCostCategoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getRuleVersion() == null ? 0 : this.getRuleVersion().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        return hashCode;
    }

    public UpdateCostCategoryDefinitionRequest clone() {
        return (UpdateCostCategoryDefinitionRequest)super.clone();
    }
}

