/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.DateInterval;
import com.amazonaws.services.costexplorer.model.ReservationAggregates;
import com.amazonaws.services.costexplorer.model.ReservationUtilizationGroup;
import com.amazonaws.services.costexplorer.model.transform.UtilizationByTimeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UtilizationByTime
implements Serializable,
Cloneable,
StructuredPojo {
    private DateInterval timePeriod;
    private List<ReservationUtilizationGroup> groups;
    private ReservationAggregates total;

    public void setTimePeriod(DateInterval timePeriod) {
        this.timePeriod = timePeriod;
    }

    public DateInterval getTimePeriod() {
        return this.timePeriod;
    }

    public UtilizationByTime withTimePeriod(DateInterval timePeriod) {
        this.setTimePeriod(timePeriod);
        return this;
    }

    public List<ReservationUtilizationGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<ReservationUtilizationGroup> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<ReservationUtilizationGroup>(groups);
    }

    public UtilizationByTime withGroups(ReservationUtilizationGroup ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<ReservationUtilizationGroup>(groups.length));
        }
        for (ReservationUtilizationGroup ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public UtilizationByTime withGroups(Collection<ReservationUtilizationGroup> groups) {
        this.setGroups(groups);
        return this;
    }

    public void setTotal(ReservationAggregates total) {
        this.total = total;
    }

    public ReservationAggregates getTotal() {
        return this.total;
    }

    public UtilizationByTime withTotal(ReservationAggregates total) {
        this.setTotal(total);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTimePeriod() != null) {
            sb.append("TimePeriod: ").append(this.getTimePeriod()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getTotal() != null) {
            sb.append("Total: ").append(this.getTotal());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtilizationByTime)) {
            return false;
        }
        UtilizationByTime other = (UtilizationByTime)obj;
        if (other.getTimePeriod() == null ^ this.getTimePeriod() == null) {
            return false;
        }
        if (other.getTimePeriod() != null && !other.getTimePeriod().equals(this.getTimePeriod())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getTotal() == null ^ this.getTotal() == null) {
            return false;
        }
        return other.getTotal() == null || other.getTotal().equals(this.getTotal());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTimePeriod() == null ? 0 : this.getTimePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getTotal() == null ? 0 : this.getTotal().hashCode());
        return hashCode;
    }

    public UtilizationByTime clone() {
        try {
            return (UtilizationByTime)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UtilizationByTimeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

