/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.ConnectionData;

@SdkInternalApi
public class ConnectionDataMarshaller {
    private static final MarshallingInfo<StructuredPojo> ATTENDEE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attendee").build();
    private static final MarshallingInfo<StructuredPojo> MEETING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Meeting").build();
    private static final ConnectionDataMarshaller instance = new ConnectionDataMarshaller();

    public static ConnectionDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConnectionData connectionData, ProtocolMarshaller protocolMarshaller) {
        if (connectionData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)connectionData.getAttendee(), ATTENDEE_BINDING);
            protocolMarshaller.marshall((Object)connectionData.getMeeting(), MEETING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

