/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.connect.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ListPhoneNumbersSummary JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListPhoneNumbersSummaryJsonUnmarshaller implements Unmarshaller<ListPhoneNumbersSummary, JsonUnmarshallerContext> {

    public ListPhoneNumbersSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        ListPhoneNumbersSummary listPhoneNumbersSummary = new ListPhoneNumbersSummary();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("PhoneNumberId", targetDepth)) {
                    context.nextToken();
                    listPhoneNumbersSummary.setPhoneNumberId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumberArn", targetDepth)) {
                    context.nextToken();
                    listPhoneNumbersSummary.setPhoneNumberArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumber", targetDepth)) {
                    context.nextToken();
                    listPhoneNumbersSummary.setPhoneNumber(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumberCountryCode", targetDepth)) {
                    context.nextToken();
                    listPhoneNumbersSummary.setPhoneNumberCountryCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumberType", targetDepth)) {
                    context.nextToken();
                    listPhoneNumbersSummary.setPhoneNumberType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TargetArn", targetDepth)) {
                    context.nextToken();
                    listPhoneNumbersSummary.setTargetArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstanceId", targetDepth)) {
                    context.nextToken();
                    listPhoneNumbersSummary.setInstanceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumberDescription", targetDepth)) {
                    context.nextToken();
                    listPhoneNumbersSummary.setPhoneNumberDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SourcePhoneNumberArn", targetDepth)) {
                    context.nextToken();
                    listPhoneNumbersSummary.setSourcePhoneNumberArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return listPhoneNumbersSummary;
    }

    private static ListPhoneNumbersSummaryJsonUnmarshaller instance;

    public static ListPhoneNumbersSummaryJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new ListPhoneNumbersSummaryJsonUnmarshaller();
        return instance;
    }
}
