/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Filters to be applied to search results.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AgentStatusSearchFilter" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AgentStatusSearchFilter implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
     * <code>OR</code> of <code>AND</code> (List of List) input where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     * </p>
     * </li>
     * </ul>
     */
    private ControlPlaneAttributeFilter attributeFilter;

    /**
     * <p>
     * An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
     * <code>OR</code> of <code>AND</code> (List of List) input where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     * </p>
     * </li>
     * </ul>
     * 
     * @param attributeFilter
     *        An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
     *        <code>OR</code> of <code>AND</code> (List of List) input where: </p>
     *        <ul>
     *        <li>
     *        <p>
     *        The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     *        </p>
     *        </li>
     */

    public void setAttributeFilter(ControlPlaneAttributeFilter attributeFilter) {
        this.attributeFilter = attributeFilter;
    }

    /**
     * <p>
     * An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
     * <code>OR</code> of <code>AND</code> (List of List) input where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     * </p>
     * </li>
     * </ul>
     * 
     * @return An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts
     *         an <code>OR</code> of <code>AND</code> (List of List) input where: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     *         </p>
     *         </li>
     */

    public ControlPlaneAttributeFilter getAttributeFilter() {
        return this.attributeFilter;
    }

    /**
     * <p>
     * An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
     * <code>OR</code> of <code>AND</code> (List of List) input where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     * </p>
     * </li>
     * </ul>
     * 
     * @param attributeFilter
     *        An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
     *        <code>OR</code> of <code>AND</code> (List of List) input where: </p>
     *        <ul>
     *        <li>
     *        <p>
     *        The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AgentStatusSearchFilter withAttributeFilter(ControlPlaneAttributeFilter attributeFilter) {
        setAttributeFilter(attributeFilter);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAttributeFilter() != null)
            sb.append("AttributeFilter: ").append(getAttributeFilter());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AgentStatusSearchFilter == false)
            return false;
        AgentStatusSearchFilter other = (AgentStatusSearchFilter) obj;
        if (other.getAttributeFilter() == null ^ this.getAttributeFilter() == null)
            return false;
        if (other.getAttributeFilter() != null && other.getAttributeFilter().equals(this.getAttributeFilter()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAttributeFilter() == null) ? 0 : getAttributeFilter().hashCode());
        return hashCode;
    }

    @Override
    public AgentStatusSearchFilter clone() {
        try {
            return (AgentStatusSearchFilter) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connect.model.transform.AgentStatusSearchFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
