/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.Channel;
import com.amazonaws.services.connect.model.transform.FiltersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Filters
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> queues;
    private List<String> channels;

    public List<String> getQueues() {
        return this.queues;
    }

    public void setQueues(Collection<String> queues) {
        if (queues == null) {
            this.queues = null;
            return;
        }
        this.queues = new ArrayList<String>(queues);
    }

    public Filters withQueues(String ... queues) {
        if (this.queues == null) {
            this.setQueues(new ArrayList<String>(queues.length));
        }
        for (String ele : queues) {
            this.queues.add(ele);
        }
        return this;
    }

    public Filters withQueues(Collection<String> queues) {
        this.setQueues(queues);
        return this;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public void setChannels(Collection<String> channels) {
        if (channels == null) {
            this.channels = null;
            return;
        }
        this.channels = new ArrayList<String>(channels);
    }

    public Filters withChannels(String ... channels) {
        if (this.channels == null) {
            this.setChannels(new ArrayList<String>(channels.length));
        }
        for (String ele : channels) {
            this.channels.add(ele);
        }
        return this;
    }

    public Filters withChannels(Collection<String> channels) {
        this.setChannels(channels);
        return this;
    }

    public Filters withChannels(Channel ... channels) {
        ArrayList<String> channelsCopy = new ArrayList<String>(channels.length);
        for (Channel value : channels) {
            channelsCopy.add(value.toString());
        }
        if (this.getChannels() == null) {
            this.setChannels(channelsCopy);
        } else {
            this.getChannels().addAll(channelsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueues() != null) {
            sb.append("Queues: ").append(this.getQueues()).append(",");
        }
        if (this.getChannels() != null) {
            sb.append("Channels: ").append(this.getChannels());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters)obj;
        if (other.getQueues() == null ^ this.getQueues() == null) {
            return false;
        }
        if (other.getQueues() != null && !other.getQueues().equals(this.getQueues())) {
            return false;
        }
        if (other.getChannels() == null ^ this.getChannels() == null) {
            return false;
        }
        return other.getChannels() == null || other.getChannels().equals(this.getChannels());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueues() == null ? 0 : this.getQueues().hashCode());
        hashCode = 31 * hashCode + (this.getChannels() == null ? 0 : this.getChannels().hashCode());
        return hashCode;
    }

    public Filters clone() {
        try {
            return (Filters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FiltersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

