/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.config.model.RecordingFrequency;
import com.amazonaws.services.config.model.ResourceType;
import com.amazonaws.services.config.model.transform.RecordingModeOverrideMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RecordingModeOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private SdkInternalList<String> resourceTypes;
    private String recordingFrequency;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public RecordingModeOverride withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getResourceTypes() {
        if (this.resourceTypes == null) {
            this.resourceTypes = new SdkInternalList();
        }
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new SdkInternalList(resourceTypes);
    }

    public RecordingModeOverride withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes((Collection<String>)new SdkInternalList(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add((Object)ele);
        }
        return this;
    }

    public RecordingModeOverride withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public RecordingModeOverride withResourceTypes(ResourceType ... resourceTypes) {
        SdkInternalList resourceTypesCopy = new SdkInternalList(resourceTypes.length);
        for (ResourceType value : resourceTypes) {
            resourceTypesCopy.add((Object)value.toString());
        }
        if (this.getResourceTypes() == null) {
            this.setResourceTypes((Collection<String>)resourceTypesCopy);
        } else {
            this.getResourceTypes().addAll((Collection<String>)resourceTypesCopy);
        }
        return this;
    }

    public void setRecordingFrequency(String recordingFrequency) {
        this.recordingFrequency = recordingFrequency;
    }

    public String getRecordingFrequency() {
        return this.recordingFrequency;
    }

    public RecordingModeOverride withRecordingFrequency(String recordingFrequency) {
        this.setRecordingFrequency(recordingFrequency);
        return this;
    }

    public RecordingModeOverride withRecordingFrequency(RecordingFrequency recordingFrequency) {
        this.recordingFrequency = recordingFrequency.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes()).append(",");
        }
        if (this.getRecordingFrequency() != null) {
            sb.append("RecordingFrequency: ").append(this.getRecordingFrequency());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingModeOverride)) {
            return false;
        }
        RecordingModeOverride other = (RecordingModeOverride)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        if (other.getResourceTypes() != null && !other.getResourceTypes().equals(this.getResourceTypes())) {
            return false;
        }
        if (other.getRecordingFrequency() == null ^ this.getRecordingFrequency() == null) {
            return false;
        }
        return other.getRecordingFrequency() == null || other.getRecordingFrequency().equals(this.getRecordingFrequency());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getRecordingFrequency() == null ? 0 : this.getRecordingFrequency().hashCode());
        return hashCode;
    }

    public RecordingModeOverride clone() {
        try {
            return (RecordingModeOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordingModeOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

