/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.PutDeliveryChannelRequest;
import com.amazonaws.services.config.model.transform.DeliveryChannelJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutDeliveryChannelRequestMarshaller
implements Marshaller<Request<PutDeliveryChannelRequest>, PutDeliveryChannelRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutDeliveryChannelRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutDeliveryChannelRequest> marshall(PutDeliveryChannelRequest putDeliveryChannelRequest) {
        if (putDeliveryChannelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putDeliveryChannelRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.PutDeliveryChannel");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putDeliveryChannelRequest.getDeliveryChannel() != null) {
                jsonGenerator.writeFieldName("DeliveryChannel");
                DeliveryChannelJsonMarshaller.getInstance().marshall(putDeliveryChannelRequest.getDeliveryChannel(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

