/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.Gpu;
import com.amazonaws.services.computeoptimizer.model.transform.GpuInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GpuInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Gpu> gpus;

    public List<Gpu> getGpus() {
        return this.gpus;
    }

    public void setGpus(Collection<Gpu> gpus) {
        if (gpus == null) {
            this.gpus = null;
            return;
        }
        this.gpus = new ArrayList<Gpu>(gpus);
    }

    public GpuInfo withGpus(Gpu ... gpus) {
        if (this.gpus == null) {
            this.setGpus(new ArrayList<Gpu>(gpus.length));
        }
        for (Gpu ele : gpus) {
            this.gpus.add(ele);
        }
        return this;
    }

    public GpuInfo withGpus(Collection<Gpu> gpus) {
        this.setGpus(gpus);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGpus() != null) {
            sb.append("Gpus: ").append(this.getGpus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GpuInfo)) {
            return false;
        }
        GpuInfo other = (GpuInfo)obj;
        if (other.getGpus() == null ^ this.getGpus() == null) {
            return false;
        }
        return other.getGpus() == null || other.getGpus().equals(this.getGpus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGpus() == null ? 0 : this.getGpus().hashCode());
        return hashCode;
    }

    public GpuInfo clone() {
        try {
            return (GpuInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GpuInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

